package fr.ifremer.adagio.core.vo.synchro;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.beans.PropertyChangeListener;

/**
 * 
 * @author Ludovic Pecquot <ludovic.pecquot@e-is.pro>
 * @since 3.7.0
 */
public class SynchroProgressionErrorVO extends SynchroProgressionVO {

	private static final long serialVersionUID = 1L;

	public SynchroProgressionErrorVO(final String errorMessage) {
		this("", errorMessage);
	}

	public SynchroProgressionErrorVO(String jobId, final String errorMessage) {
		super(jobId, "", new SynchroProgressionModel() {
			private static final long serialVersionUID = 1L;

			@Override
			public String getMessage() {
				return errorMessage;
			}

			@Override
			public void setTask(String task) {
			}

			@Override
			public String getTask() {
				return "";
			}

			@Override
			public void setMessage(String message) {
			}

			@Override
			public int getCurrent() {
				return 0;
			}

			@Override
			public void setCurrent(int progression) {
			}

			@Override
			public void increments(int increment) {
			}

			@Override
			public void increments(String message) {
			}

			@Override
			public SynchroProgressionStatus getStatus() {
				return SynchroProgressionStatus.FAILED;
			}

			@Override
			public void setStatus(SynchroProgressionStatus progressionStatus) {
			}

			@Override
			public void addPropertyChangeListener(PropertyChangeListener listener) {
			}

			@Override
			public void removePropertyChangeListener(PropertyChangeListener listener) {
			}
		});
	}

}
