package fr.ifremer.adagio.core.vo.synchro;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.Serializable;
import java.util.Date;

import com.google.common.collect.Multimap;

/**
 * 
 * @author Ludovic Pecquot <ludovic.pecquot@e-is.pro>
 * @since 3.7.0
 */
public class SynchroImportContextVO implements Serializable {

	private static final long serialVersionUID = 2375804877480968569L;

	public static final String PROPERTY_JOB_ID = "jobId";
	public static final String PROPERTY_REFERENTIAL_UPDATE_DATE = "referentialUpdateDate";
	public static final String PROPERTY_DATA_UPDATE_DATE = "dataUpdateDate";
	public static final String PROPERTY_DATA_START_DATE = "dataStartDate";
	public static final String PROPERTY_DATA_END_DATE = "dataEndDate";
	public static final String PROPERTY_REFERENTIAL = "referential";
	public static final String PROPERTY_DATA = "data";
	public static final String PROPERTY_DATA_PK_INCLUDES = "dataPkIncludes";

	private String jobId;
	private Date referentialUpdateDate;
	private Date dataUpdateDate;
	private Date dataStartDate;
	private Date dataEndDate;
	private boolean referential;
	private boolean data;
	private Multimap<String, String> dataPkIncludes;

	public SynchroImportContextVO() {
	}

	public String getJobId() {
		return jobId;
	}

	public void setJobId(String jobId) {
		this.jobId = jobId;
	}

	public Date getReferentialUpdateDate() {
		return referentialUpdateDate;
	}

	public void setReferentialUpdateDate(Date referentialUpdateDate) {
		this.referentialUpdateDate = referentialUpdateDate;
	}

	public Date getDataUpdateDate() {
		return dataUpdateDate;
	}

	public void setDataUpdateDate(Date dataUpdateDate) {
		this.dataUpdateDate = dataUpdateDate;
	}

	public Date getDataStartDate() {
		return dataStartDate;
	}

	public void setDataStartDate(Date dataStartDate) {
		this.dataStartDate = dataStartDate;
	}

	public Date getDataEndDate() {
		return dataEndDate;
	}

	public void setDataEndDate(Date dataEndDate) {
		this.dataEndDate = dataEndDate;
	}

	public boolean isReferential() {
		return referential;
	}

	public void setReferential(boolean referential) {
		this.referential = referential;
	}

	public boolean isData() {
		return data;
	}

	public void setData(boolean data) {
		this.data = data;
	}

	public Multimap<String, String> getDataPkIncludes() {
		return dataPkIncludes;
	}

	public void setDataPkIncludes(Multimap<String, String> dataPkIncludes) {
		this.dataPkIncludes = dataPkIncludes;
	}

}
