package fr.ifremer.adagio.core.service.technical.synchro.specific;

/*
 * #%L
 * Tutti :: Persistence
 * $Id: VesselFeaturesReferentialSynchroSpecificTableTaskImpl.java 1573 2014-02-04 16:41:40Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/trunk/tutti-persistence/src/main/java/fr/ifremer/adagio/core/service/technical/synchro/specific/VesselFeaturesReferentialSynchroSpecificTableTaskImpl.java $
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.common.collect.Maps;

import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroDatabaseMetadata;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroTableMetadata;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroTableTool;

/**
 * Created on 1/15/14.
 * 
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 3.0
 * @deprecated Use
 *             fr.ifremer.adagio.service.synchro.referential.intercept.
 *             VesselFeaturesReferentialSynchroSpecificTableTaskImpl
 */
public class VesselFeaturesReferentialSynchroSpecificTableTaskImpl implements ReferentialSynchroSpecificTableTask {
	@Override
	public String getTable() {
		return "VESSEL_FEATURES";
	}

	@Override
	public Map<List<Object>, Object[]> transformExtraLocalData(ReferentialSynchroDatabaseMetadata dbMetas,
			ReferentialSynchroTableTool localDao,
			ReferentialSynchroTableTool remoteDao,
			Map<List<Object>, Object[]> extraRows) throws SQLException {

		// get all vessel codes already existing in remove db

		ReferentialSynchroTableMetadata vesselTable =
				dbMetas.getTable("VESSEL");

		ReferentialSynchroTableTool remoteVesselDao =
				new ReferentialSynchroTableTool(remoteDao, vesselTable);

		Set<String> existingVesselCodes = remoteVesselDao.getExistingPrimaryKeys();

		ReferentialSynchroTableMetadata table = localDao.getTable();

		int columnIndex = table.getColumnIndex("vessel_fk");

		Map<List<Object>, Object[]> result = Maps.newHashMap();

		for (Map.Entry<List<Object>, Object[]> entry : extraRows.entrySet()) {
			Object[] row = entry.getValue();
			Object vesselCode = row[columnIndex];
			if (!existingVesselCodes.contains(String.valueOf(vesselCode))) {

				// really a features from a the local db (temporary data for example, keep it)
				result.put(entry.getKey(), entry.getValue());
			}
		}
		return result;
	}
}
