package fr.ifremer.adagio.core.service.technical.synchro.specific;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id: TranscribingItemDeleteTaskImpl.java 12257 2014-09-15 14:29:49Z tc1fbb1 $
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroDatabaseMetadata;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroTableTool;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

/**
 * On transcribingItem we need to remove doubloons.
 * 
 * Created on 9/12/14.
 * 
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.6.3
 */
public class TranscribingItemDeleteTaskImpl implements ReferentialDeleteTask {

	@Override
	public String getTable() {
		return "TRANSCRIBING_ITEM";
	}

	@Override
	public Set<List<Object>> getIdsToDelete(ReferentialSynchroDatabaseMetadata dbMetas,
			ReferentialSynchroTableTool localDao) throws SQLException {

		PreparedStatement prepareStatement = localDao
				.createPrepareStatement("SELECT (t1.OBJECT_ID || '--' ||  t1.TRANSCRIBING_ITEM_TYPE_FK) AS naturalKey, t1.ID\n" +
						" FROM TRANSCRIBING_ITEM t1, TRANSCRIBING_ITEM t2\n" +
						" WHERE\n" +
						" t1.ID != t2.ID\n" +
						" AND t1.OBJECT_ID = t2.OBJECT_ID\n" +
						" AND t1.TRANSCRIBING_ITEM_TYPE_FK = t2.TRANSCRIBING_ITEM_TYPE_FK\n" +
						" ORDER BY naturalKey, UPDATE_DATE DESC;");

		ResultSet resultSet = prepareStatement.executeQuery();

		Set<List<Object>> result = Sets.newHashSet();

		String previousNaturalKey = "";
		while (resultSet.next()) {

			String naturalKey = resultSet.getString(1);

			if (!previousNaturalKey.equals(naturalKey)) {

				// got a new natural key
				// will keep it in table (the one with latest update_date)
				previousNaturalKey = naturalKey;
				continue;

			}

			// still on same natural key, must remove it
			Integer id = resultSet.getInt(2);
			result.add(Lists.<Object> newArrayList(id));

		}

		return result;

	}
}