package fr.ifremer.adagio.core.service.technical.synchro.specific;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id: ReferentialDeleteTask.java 12431 2014-11-21 15:55:30Z bl05b3e $
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroDatabaseMetadata;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroServiceImpl;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroTableTool;

/**
 * Created on 9/12/14.
 * 
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.6.3
 */
public interface ReferentialDeleteTask {

	String getTable();

	/**
	 * Get ids to delete from the local table.
	 * 
	 * <strong>Note: </strong> this metod will only be invoked while using the non big table code
	 * ({@link ReferentialSynchroServiceImpl#updateBigTable(SynchroTableDao, SynchroTableDao, ResultSet, SynchroResult)}
	 * ).
	 * 
	 * @param dbMetas
	 *            metas of db
	 * @param localDao
	 *            dao of local table
	 * @return the set of pks to remove
	 * @throws SQLException
	 */
	Set<List<Object>> getIdsToDelete(ReferentialSynchroDatabaseMetadata dbMetas,
			ReferentialSynchroTableTool localDao) throws SQLException;
}
