package fr.ifremer.adagio.core.service.technical.synchro;

/*
 * #%L
 * Tutti :: Persistence API
 * $Id: ReferentialSynchroResult.java 1486 2014-01-15 08:43:26Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/trunk/tutti-persistence/src/main/java/fr/ifremer/adagio/core/service/technical/synchro/ReferentialSynchroResult.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.type.ProgressionModel;
import org.apache.commons.lang3.mutable.MutableInt;

import java.sql.Timestamp;
import java.util.Map;
import java.util.Set;

/**
 * Result of a referential synchronize operation.
 * 
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 * @deprecated Use fr.ifremer.adagio.synchro.service.SynchroResult
 */
public class ReferentialSynchroResult {

	protected Exception error;

	/**
	 * Number of rows detected to update (per table).
	 * 
	 * @since 1.0
	 */
	protected final Map<String, MutableInt> rowHits = Maps.newTreeMap();

	/**
	 * Number of insert done (per table).
	 * 
	 * @since 1.0
	 */
	protected final Map<String, MutableInt> insertHits = Maps.newTreeMap();

	/**
	 * Number of update done (per table).
	 * 
	 * @since 1.0
	 */
	protected final Map<String, MutableInt> updateHits = Maps.newTreeMap();

	/**
	 * Number of delete done (per table).
	 * 
	 * @since 3.6.3
	 */
	protected final Map<String, MutableInt> deleteHits = Maps.newTreeMap();

	/**
	 * timestamp of last update date (per table).
	 * 
	 * @since 1.0
	 */
	protected final Map<String, Timestamp> updateDateHits = Maps.newTreeMap();

	/**
	 * All table treated.
	 * 
	 * @since 1.0
	 */
	protected final Set<String> tableNames = Sets.newHashSet();

	protected String localUrl;

	protected String remoteUrl;

	protected final ProgressionModel progressionModel = new ProgressionModel(this);

	public ReferentialSynchroResult() {
	}

	public ReferentialSynchroResult(String localUrl, String remoteUrl) {
		this.localUrl = localUrl;
		this.remoteUrl = remoteUrl;
	}

	public void setLocalUrl(String localUrl) {
		this.localUrl = localUrl;
	}

	public void setRemoteUrl(String remoteUrl) {
		this.remoteUrl = remoteUrl;
	}

	public boolean isSuccess() {
		return error == null;
	}

	public Exception getError() {
		return error;
	}

	public void setError(Exception error) {
		this.error = error;
	}

	public ProgressionModel getProgressionModel() {
		return progressionModel;
	}

	public Set<String> getTableNames() {
		return ImmutableSet.copyOf(tableNames);
	}

	public int getTotalRows() {
		int result = 0;
		for (MutableInt nb : rowHits.values()) {
			result += nb.intValue();
		}
		return result;
	}

	public int getTotalInserts() {
		int result = 0;
		for (MutableInt nb : insertHits.values()) {
			result += nb.intValue();
		}
		return result;
	}

	public int getTotalUpdates() {
		int result = 0;
		for (MutableInt nb : updateHits.values()) {
			result += nb.intValue();
		}
		return result;
	}

	public int getTotalDeletes() {
		int result = 0;
		for (MutableInt nb : deleteHits.values()) {
			result += nb.intValue();
		}
		return result;
	}

	public int getNbRows(String tableName) {
		int r = 0;
		MutableInt result = rowHits.get(tableName);
		if (result != null) {
			r = result.intValue();
		}
		return r;
	}

	public int getNbInserts(String tableName) {
		int r = 0;
		MutableInt result = insertHits.get(tableName);
		if (result != null) {
			r = result.intValue();
		}
		return r;
	}

	public int getNbUpdates(String tableName) {
		int r = 0;
		MutableInt result = updateHits.get(tableName);
		if (result != null) {
			r = result.intValue();
		}
		return r;
	}

	public int getNbDeletes(String tableName) {
		int r = 0;
		MutableInt result = deleteHits.get(tableName);
		if (result != null) {
			r = result.intValue();
		}
		return r;
	}

	public void addRows(String tableName, int nb) {
		if (nb > 0) {
			MutableInt mutableInt = rowHits.get(tableName);
			if (mutableInt == null) {
				mutableInt = new MutableInt();
				rowHits.put(tableName, mutableInt);
			}
			mutableInt.add(nb);
		}
	}

	public void addUpdates(String tableName, int nb) {
		if (nb > 0) {
			MutableInt mutableInt = updateHits.get(tableName);
			if (mutableInt == null) {
				mutableInt = new MutableInt();
				updateHits.put(tableName, mutableInt);
			}
			mutableInt.add(nb);
		}
	}

	public void addDeletes(String tableName, int nb) {
		if (nb > 0) {
			MutableInt mutableInt = deleteHits.get(tableName);
			if (mutableInt == null) {
				mutableInt = new MutableInt();
				deleteHits.put(tableName, mutableInt);
			}
			mutableInt.add(nb);
		}
	}

	public void addInserts(String tableName, int nb) {
		if (nb > 0) {
			MutableInt mutableInt = insertHits.get(tableName);
			if (mutableInt == null) {
				mutableInt = new MutableInt();
				insertHits.put(tableName, mutableInt);
			}
			mutableInt.add(nb);
		}
	}

	public Timestamp getUpdateDate(String tableName) {
		return updateDateHits.get(tableName);
	}

	public void setUpdateDate(String tableName, Timestamp t) {
		updateDateHits.put(tableName, t);
	}

	public void addTableName(String tableName) {
		tableNames.add(tableName);
	}

	public String getLocalUrl() {
		return localUrl;
	}

	public String getRemoteUrl() {
		return remoteUrl;
	}
}
