package fr.ifremer.adagio.core.service.technical.synchro;

/*
 * #%L
 * Tutti :: Persistence
 * $Id: ReferentialSynchroDatabaseMetadata.java 1573 2014-02-04 16:41:40Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/trunk/tutti-persistence/src/main/java/fr/ifremer/adagio/core/service/technical/synchro/ReferentialSynchroDatabaseMetadata.java $
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.AdagioTechnicalException;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import static org.nuiton.i18n.I18n.t;

/**
 * Created on 1/14/14.
 * 
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 3.5
 * @deprecated Use fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata
 */
public class ReferentialSynchroDatabaseMetadata {

	/** Logger. */
	private static final Log log =
			LogFactory.getLog(ReferentialSynchroDatabaseMetadata.class);

	/**
	 * Load the datasource schema for the given connection and dialect.
	 * 
	 * @param tablesToSynch
	 *            tables to synch
	 * @param connection
	 *            connection of the data source
	 * @param dialect
	 *            dialect to use
	 * @return the datasource schema
	 */
	public static ReferentialSynchroDatabaseMetadata loadDatabaseMetadata(Set<String> tablesToSynch,
			Connection connection,
			Dialect dialect) {
		ReferentialSynchroDatabaseMetadata result = new ReferentialSynchroDatabaseMetadata(tablesToSynch, connection, dialect);
		for (String tableName : tablesToSynch) {
			if (StringUtils.isNotBlank(tableName)) {
				if (log.isDebugEnabled()) {
					log.debug("Load metas of table: " + tableName);
				}
				result.getTable(tableName);
			}
		}
		return result;
	}

	protected final Set<String> tablesToSynchNames;

	protected final DatabaseMetadata delegate;

	protected final Map<String, ReferentialSynchroTableMetadata> tables;

	protected final DatabaseMetaData meta;

	public ReferentialSynchroDatabaseMetadata(Set<String> tablesToSynch, Connection connection, Dialect dialect) {
		Preconditions.checkNotNull(tablesToSynch);
		Preconditions.checkNotNull(connection);
		Preconditions.checkNotNull(dialect);
		this.tablesToSynchNames = new HashSet<String>(tablesToSynch);

		try {
			this.delegate = new DatabaseMetadata(connection, dialect, true);
			this.meta = connection.getMetaData();
		} catch (SQLException e) {
			throw new AdagioTechnicalException(t("adagio.persistence.dbMetadata.instanciation.error", connection), e);
		}
		tables = Maps.newTreeMap();
	}

	public ReferentialSynchroTableMetadata getTable(String name) throws HibernateException {
		return getTable(name, "PUBLIC", null, false);
	}

	public int getTableCount() {
		return tables.size();
	}

	public Set<String> getTableNames() {
		Set<String> result = Sets.newHashSet();
		for (ReferentialSynchroTableMetadata tableMetadata : tables.values()) {
			result.add(tableMetadata.getName());
		}
		return result;
	}

	protected ReferentialSynchroTableMetadata getTable(String name,
			String schema,
			String catalog,
			boolean isQuoted) throws HibernateException {
		String key = Table.qualify(catalog, schema, name);
		ReferentialSynchroTableMetadata tuttiTableMetadata = tables.get(key);
		if (tuttiTableMetadata == null) {

			TableMetadata tableMetadata = delegate.getTableMetadata(
					name, schema, catalog, isQuoted);
			Preconditions.checkNotNull(tableMetadata,
					"Could not find db table " + name);
			Preconditions.checkNotNull(tablesToSynchNames.contains(name),
					"Could not find db table " + name);
			tuttiTableMetadata = new ReferentialSynchroTableMetadata(tableMetadata, meta);
			Preconditions.checkNotNull(tuttiTableMetadata,
					"Could not find db table " + name);
			tables.put(key, tuttiTableMetadata);
		}
		return tuttiTableMetadata;
	}
}
