package fr.ifremer.adagio.core.service.technical.sanity;

/*
 * #%L
 * Tutti :: Persistence
 * $Id: DatabaseSanityServiceImpl.java 1573 2014-02-04 16:41:40Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/trunk/tutti-persistence/src/main/java/fr/ifremer/adagio/core/service/technical/sanity/DatabaseSanityServiceImpl.java $
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.ServiceLoader;
import java.util.Set;

import javax.annotation.Resource;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Sets;

import fr.ifremer.adagio.core.service.technical.CacheService;
import fr.ifremer.adagio.core.service.technical.sanity.task.DatabaseSanityTask;

/**
 * Default implementation of the {@link DatabaseSanityServiceWriteTest}.
 * <p/>
 * Created on 1/18/14.
 * 
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 3.5
 */
@Service("databaseSanityService")
@Lazy
public class DatabaseSanityServiceImpl implements DatabaseSanityService {

	/**
	 * Session factory.
	 */
	@Autowired
	protected SessionFactory sessionFactory;

	/**
	 * Cache service.
	 */
	@Resource(name = "cacheService")
	protected CacheService cacheService;

	@Override
	public void sanity() {

		Session currentSession = sessionFactory.getCurrentSession();

		Set<String> cacheIds = Sets.newHashSet();

		for (DatabaseSanityTask checker : ServiceLoader.load(DatabaseSanityTask.class)) {
			Set<String> ids = checker.sanity(currentSession);
			cacheIds.addAll(ids);
		}

		// clear caches
		for (String cacheId : cacheIds) {
			cacheService.clearCache(cacheId);
		}
	}
}
