package fr.ifremer.adagio.core.service.referential.synchro.intercept;

/*
 * #%L
 * Tutti :: Persistence
 * $Id: VesselFeaturesReferentialSynchroSpecificTableTaskImpl.java 1573 2014-02-04 16:41:40Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/trunk/tutti-persistence/src/main/java/fr/ifremer/adagio/core/service/technical/synchro/specific/VesselFeaturesReferentialSynchroSpecificTableTaskImpl.java $
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.hibernate.tool.hbm2ddl.TableMetadata;

import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;

/**
 * Created on 1/15/14.
 * 
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 3.0
 */
public class VesselTablesExtraLocalDataInterceptor extends ReferentialAbstractSynchroInterceptor {

	private SynchroDatabaseMetadata dbMeta = null;

	@Override
	public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
		if (dbMeta == null) {
			this.dbMeta = meta;
		}
		String tableName = table.getName();
		return "VESSEL_FEATURES".equalsIgnoreCase(tableName)
				|| "VESSEL_REGISTRATION_PERIOD".equalsIgnoreCase(tableName);
	}

	/*
	 * @Override
	 * protected Map<List<Object>, Object[]> doTransformExtraLocalData(SynchroTableDao targetDao, SynchroTableDao
	 * sourceDao,
	 * java.util.Map<java.util.List<Object>, Object[]> extraRows) throws SQLException {
	 * SynchroTableMetadata targetTable = targetDao.getTable();
	 * 
	 * // get all vessel codes already existing in source db
	 * SynchroTableDao sourceVesselDao = sourceDao.getDaoFactory().getSourceDao("VESSEL");
	 * Set<String> existingVesselCodes = sourceVesselDao.getPksStr();
	 * IOUtils.closeQuietly(sourceVesselDao);
	 * 
	 * int columnIndex = targetTable.getColumnIndex("vessel_fk");
	 * 
	 * Map<List<Object>, Object[]> result = Maps.newHashMap();
	 * 
	 * for (Map.Entry<List<Object>, Object[]> entry : extraRows.entrySet()) {
	 * Object[] row = entry.getValue();
	 * Object vesselCode = row[columnIndex];
	 * if (!existingVesselCodes.contains(String.valueOf(vesselCode))) {
	 * 
	 * // really a features from a the local db (temporary data for example, keep it)
	 * result.put(entry.getKey(), entry.getValue());
	 * }
	 * }
	 * return result;
	 * }
	 */

}
