package fr.ifremer.adagio.core.service.referential.synchro.intercept;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.apache.commons.lang3.StringUtils;
import org.hibernate.tool.hbm2ddl.TableMetadata;

import com.google.common.eventbus.Subscribe;

import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.adagio.synchro.query.SynchroQueryBuilder;
import fr.ifremer.adagio.synchro.query.SynchroQueryOperator;

public class TranscribingItemInterceptor extends ReferentialAbstractSynchroInterceptor {

	public static final String COLUMN_TRANSCRIBING_ITEM_TYPE_FK = "transcribing_item_type_fk";

	@Override
	public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
		return "TRANSCRIBING_ITEM".equalsIgnoreCase(table.getName());
	}

	@Subscribe
	public void handleCreateQuery(CreateQueryEvent e) {
		switch (e.queryName) {
		case count:
		case countFromUpdateDate:
		case select:
		case selectFromUpdateDate:
		case selectMaxUpdateDate:
			String transcribingTypeIds = AdagioConfiguration.getInstance().getImportTranscribingItemTypeIds();
			if (StringUtils.isBlank(transcribingTypeIds)) {
				transcribingTypeIds = "-1";
			}
			// Add restriction transcribing type
			e.sql = SynchroQueryBuilder.newBuilder(e.sql)
					.addWhere(SynchroQueryOperator.AND, String.format("%s in (%s)",
							COLUMN_TRANSCRIBING_ITEM_TYPE_FK,
							transcribingTypeIds))
					.build();
			break;

		default:
			break;
		}
	}
}
