package fr.ifremer.adagio.core.service.referential.synchro.intercept;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.hibernate.tool.hbm2ddl.TableMetadata;

import com.google.common.base.Preconditions;

import fr.ifremer.adagio.core.service.data.synchro.DataSynchroDatabaseConfiguration;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.service.SynchroDatabaseConfiguration;

public abstract class ReferentialAbstractSynchroInterceptor extends SynchroInterceptorBase {

	private SynchroDatabaseMetadata meta;

	public ReferentialAbstractSynchroInterceptor() {
	}

	@Override
	public SynchroInterceptorBase clone() {
		ReferentialAbstractSynchroInterceptor result = (ReferentialAbstractSynchroInterceptor) super.clone();
		result.meta = this.meta;
		return result;
	}

	@Override
	public boolean apply(SynchroDatabaseConfiguration config) {
		boolean result = !(config instanceof DataSynchroDatabaseConfiguration)
				/* super is need to store the config into a field */
				&& super.apply(config);

		if (result) {
			// Init the interceptor
			init(config);
		}
		return result;
	}

	@Override
	public final boolean apply(SynchroDatabaseMetadata meta, TableMetadata table) {
		Preconditions.checkNotNull(meta);
		if (this.meta != null) {
			Preconditions.checkState(this.meta == meta);
		}

		// Store meta and configuration
		else {
			this.meta = meta;
		}

		return doApply(meta, table);
	}

	public abstract boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table);

	public SynchroDatabaseConfiguration getConfig() {
		return getDefaultDatabaseConfiguration();
	}

	/* -- internal methods -- */

	protected void init(SynchroDatabaseConfiguration config) {
		// could be override
	}

}
