package fr.ifremer.adagio.core.service.referential.synchro;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.File;
import java.sql.Timestamp;
import java.util.Properties;

import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import fr.ifremer.adagio.synchro.service.SynchroContext;
import fr.ifremer.adagio.synchro.type.ProgressionModel;

@Transactional(readOnly = true, propagation = Propagation.NOT_SUPPORTED)
public interface ReferentialSynchroService {

	/**
	 * Create a synchro context, from a source database directory (HSQLDB only), and with a last synchronization date.
	 * This use local connection properties as source properties, but change JDBC URL to use the given directory
	 * 
	 * @param sourceDbDirectory
	 *            a directory with a HSQLDB directory.
	 * @param lastSynchronizationDate
	 *            the last synchro date
	 * @return a new context for synchronization
	 */
	SynchroContext createSynchroContext(File sourceDbDirectory, Timestamp lastSynchronizationDate);

	/**
	 * Create a synchro context, using configuration properties for target and source properties, and with a last
	 * synchronization date.
	 * 
	 * @param sourceConnectionProperties
	 *            Properties to use as source connection (could be Oracle, HSQLDB...)
	 * @param lastSynchronizationDate
	 *            the last synchro date
	 * @return a new context for synchronization
	 */
	SynchroContext createSynchroContext(Properties sourceConnectionProperties, Timestamp lastSynchronizationDate);

	/**
	 * Prepare the synchronize operation from the target data database supported
	 * by this service, says just compute nb rows to update for each table and
	 * update the result model.
	 * 
	 * @param synchroContext
	 *            Context of synchronization
	 */
	@Transactional(readOnly = false, propagation = Propagation.REQUIRED)
	void prepare(SynchroContext synchroContext);

	/**
	 * Launch the synchronize operation from the target data database supported
	 * by this service.
	 * 
	 * @param synchroContext
	 *            Context of synchronization
	 */
	@Transactional(readOnly = false, propagation = Propagation.REQUIRED)
	void synchronize(SynchroContext synchroContext);

	@Transactional(readOnly = true, propagation = Propagation.REQUIRED)
	Timestamp getSourceLastUpdateDate(SynchroContext synchroContext);
}
