package fr.ifremer.adagio.core.service.data.synchro.intercept;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.hibernate.tool.hbm2ddl.TableMetadata;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;

import fr.ifremer.adagio.core.service.data.synchro.DataSynchroDirection;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata.DuplicateKeyStrategy;
import fr.ifremer.adagio.synchro.meta.event.LoadPkEvent;
import fr.ifremer.adagio.synchro.meta.event.LoadTableEvent;
import java.util.Set;

/**
 * 
 * @author Benoit Lavenier <benoit.lavenier@e-is.pro>
 * @since 3.7.0
 * 
 */
public class ProduceSortingMeasurementInterceptor extends DataAbstractSynchroInterceptor {

	public static final String COLUMN_PRODUCE_FK = "produce_fk";

	public ProduceSortingMeasurementInterceptor() {
		super(DataSynchroDirection.EXPORT_TEMP2SERVER,
				DataSynchroDirection.IMPORT_TEMP2LOCAL);
	}

	@Override
	public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
		return "SORTING_MEASUREMENT_P".equalsIgnoreCase(table.getName());
	}

	@Subscribe
	public void handleLoadTable(LoadTableEvent e) {

		// If export (Temp DB -> server DB)
		if (getConfig().getDirection() == DataSynchroDirection.EXPORT_TEMP2SERVER) {
			String remoteIdColumn = getConfig().getColumnRemoteId();
			String idColumn = getConfig().getColumnId();

			// Override natural ID, to use 'ID' and 'PRODUCE_FK'
			e.table.putUniqueConstraint(remoteIdColumn, ImmutableList.of(idColumn, COLUMN_PRODUCE_FK), DuplicateKeyStrategy.REPLACE);
		}
	}

	@Subscribe
	public void handlePkLoad(LoadPkEvent e) {
		Set<String> pk = e.pk;

		// If export (Temp DB -> server DB)
		if (getConfig().getDirection() == DataSynchroDirection.EXPORT_TEMP2SERVER) {

			// Add produce_fk as primary key component (need for performence - mantis #23391)
			if (pk != null && !pk.contains(COLUMN_PRODUCE_FK)) {
				pk.add(COLUMN_PRODUCE_FK);
			}
		}
	}
}
