package fr.ifremer.adagio.core.service.data.synchro.intercept;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.hibernate.tool.hbm2ddl.TableMetadata;

import com.google.common.eventbus.Subscribe;

import fr.ifremer.adagio.core.service.data.synchro.DataSynchroDirection;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.event.CreateQueryEvent;
import fr.ifremer.adagio.synchro.meta.event.LoadTableEvent;
import fr.ifremer.adagio.synchro.query.SynchroQueryBuilder;
import fr.ifremer.adagio.synchro.query.SynchroQueryOperator;

/**
 * 
 * @author Benoit Lavenier <benoit.lavenier@e-is.pro>
 * @since 3.5.0
 * 
 */
public class PersonSessionInterceptor extends DataAbstractSynchroInterceptor {

	public PersonSessionInterceptor() {
		// Enable only on import (not need for export)
		super(DataSynchroDirection.IMPORT_SERVER2TEMP, DataSynchroDirection.IMPORT_TEMP2LOCAL);
	}

	@Override
	public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
		return "PERSON_SESSION".equalsIgnoreCase(table.getName());
	}

	@Subscribe
	public void handleLoadTable(LoadTableEvent e) {
		e.table.setRoot(true);
	}

	@Subscribe
	public void handleCreateQuery(CreateQueryEvent e) {
		switch (e.queryName) {
		// Select queries : remove unsed columns
		case count:
		case countFromUpdateDate:
		case select:
		case selectFromUpdateDate:
		case selectMaxUpdateDate:
			if (getConfig().getDirection() == DataSynchroDirection.IMPORT_SERVER2TEMP) {
				// Limit to user current session id
				int sessionId = checkAndGetPersonSessionId();
				e.sql = SynchroQueryBuilder.newBuilder(e.sql)
						.addWhere(SynchroQueryOperator.AND, "t.id", String.valueOf(sessionId))
						.build();
			}
			break;

		default:
			break;
		}
	}
}
