package fr.ifremer.adagio.core.service.data.synchro.intercept;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Preconditions;

import fr.ifremer.adagio.core.service.data.synchro.DataSynchroContext;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptor;
import fr.ifremer.adagio.synchro.service.SynchroContext;

public class PersonSessionHelper {

	public static int checkAndGetPersonSessionId(SynchroContext context, Class<? extends SynchroInterceptor> interceptorClass) {
		Preconditions.checkNotNull(context,
				String.format("%s need a not null context.", interceptorClass.getSimpleName()));

		Preconditions.checkArgument(context instanceof DataSynchroContext,
				String.format(
						"%s need a %s context class.", interceptorClass.getSimpleName(),
						DataSynchroContext.class.getSimpleName()));

		DataSynchroContext allegroContext = (DataSynchroContext) context;
		Integer sessionId = allegroContext.getSessionId();

		Preconditions
				.checkNotNull(
						sessionId,
						String.format(
								"Could not retrieve user session (no sessionId in context). %s need a %s with a not null sessionId. Please call setSessionId() before using this interceptor",
								interceptorClass.getSimpleName(),
								DataSynchroContext.class.getSimpleName()));

		return sessionId;

	}

}
