package fr.ifremer.adagio.core.service.data.synchro.intercept;

/*
 * #%L
 * SIH-Adagio :: Synchronization
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.hibernate.tool.hbm2ddl.TableMetadata;

import com.google.common.eventbus.Subscribe;

import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.event.LoadJoinEvent;

public class GearPhysicalFeaturesInterceptor extends DataAbstractSynchroInterceptor {

	public static final String TARGET_TABLE_OPERATION = "OPERATION";
	public static final String TARGET_COLUMN_GEAR_PHYSICAL_FEATURES = "gear_physical_features_fk";

	@Override
	public boolean doApply(SynchroDatabaseMetadata meta, TableMetadata table) {
		return "GEAR_PHYSICAL_FEATURES".equalsIgnoreCase(table.getName());
	}

	@Subscribe
	public void handleJoinLoad(LoadJoinEvent e) {
		if (!e.join.isValid()) {
			return;
		}

		// Disable join between OPERATION and GEAR_PHYSICAL_FEATURES
		String targetTableName = e.join.getTargetTable().getName();
		String targetColumnName = e.join.getTargetColumn().getName();
		boolean isJoinToOperationTable = TARGET_TABLE_OPERATION.equalsIgnoreCase(targetTableName)
				&& TARGET_COLUMN_GEAR_PHYSICAL_FEATURES.equalsIgnoreCase(targetColumnName);

		if (isJoinToOperationTable) {
			e.join.setIsValid(false);
		}
	}
}
