package fr.ifremer.adagio.core.service.data.synchro;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Date;

import com.google.common.collect.Multimap;

import fr.ifremer.adagio.synchro.config.SynchroConfiguration;
import fr.ifremer.adagio.synchro.service.SynchroContext;

public class DataSynchroContext extends SynchroContext {

	private Integer userId;

	private Integer sessionId;

	private DataSynchroDirection direction;

	protected Date dataStartDate;

	protected Date dataEndDate;

	protected Multimap<String, String> pkIncludes;

	public DataSynchroContext(DataSynchroDirection direction, Integer userId) {
		this.userId = userId;
		this.sessionId = null;
		this.direction = direction;
	}

	public DataSynchroContext(SynchroContext delegate, DataSynchroDirection direction, Integer userId) {
		super(delegate);
		this.userId = userId;
		this.sessionId = null;
		this.direction = direction;
	}

	public DataSynchroContext(SynchroContext delegate, DataSynchroDirection direction, Integer userId, Integer sessionId) {
		super(delegate);
		this.userId = userId;
		this.sessionId = sessionId;
		this.direction = direction;
	}

	public Integer getUserId() {
		return userId;
	}

	public void setUserId(Integer userId) {
		this.userId = userId;
	}

	public Integer getSessionId() {
		return this.sessionId;
	}

	public void setSessionId(Integer sessionId) {
		this.sessionId = sessionId;
	}

	public boolean isUserLogged() {
		return sessionId != null && userId != null;
	}

	public DataSynchroDirection getDirection() {
		return direction;
	}

	public void setDirection(DataSynchroDirection direction) {
		this.direction = direction;
	}

	public Date getDataStartDate() {
		return dataStartDate;
	}

	public void setDataStartDate(Date dataStartDate) {
		this.dataStartDate = dataStartDate;
	}

	public Date getDataEndDate() {
		return dataEndDate;
	}

	public void setDataEndDate(Date dataEndDate) {
		this.dataEndDate = dataEndDate;
	}

	public void setPkIncludes(Multimap<String, String> pkIncludes) {
		this.pkIncludes = pkIncludes;
	}

	public Multimap<String, String> getPkIncludes() {
		return this.pkIncludes;
	}

	@Override
	public void copy(SynchroContext otherBean) {
		super.copy(otherBean);

		SynchroConfiguration config = SynchroConfiguration.getInstance();
		// Change database configuration class
		if (otherBean.getTarget() != null) {
			setTarget(new DataSynchroDatabaseConfiguration(config, this, otherBean.getTarget().getProperties(), true));
		}
		if (otherBean.getSource() != null) {
			setSource(new DataSynchroDatabaseConfiguration(config, this, otherBean.getSource().getProperties(), false));
		}

		if (otherBean instanceof DataSynchroContext) {
			this.userId = ((DataSynchroContext) otherBean).userId;
			this.sessionId = ((DataSynchroContext) otherBean).sessionId;
			this.direction = ((DataSynchroContext) otherBean).direction;
			this.dataStartDate = ((DataSynchroContext) otherBean).dataStartDate;
			this.dataEndDate = ((DataSynchroContext) otherBean).dataEndDate;
			this.pkIncludes = ((DataSynchroContext) otherBean).pkIncludes;
		}
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder(super.toString());
		sb.append("\n  direction: ").append(getDirection());
		sb.append("\n  user id: ").append(getUserId());
		sb.append("\n  session id: ").append(getSessionId());

		if (getDataStartDate() != null) {
			sb.append("\n  data start date: ").append(getDataStartDate());
			sb.append("\n         end date: ").append(getDataEndDate());
		}
		if (getPkIncludes() != null) {
			sb.append("\n  PK includes: ").append(getPkIncludes().toString());
		}
		return sb.toString();
	}
}
