package fr.ifremer.adagio.core.dao.technical.synchronization;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.sql.SQLException;
import java.util.List;

public interface TempQueryParameterExtendDao extends TempQueryParameterDao {

	/**
	 * Remove rows from TempQueryparameter, using the parameter name and the user id
	 * 
	 * @param queryParameterName
	 * @param likeOperatorForParameterName
	 *            if true, use a 'like' instead of 'equals'
	 * @param queryPersonId
	 * @throws SQLException
	 */
	public void removeByParameterName(String queryParameterName, boolean likeOperatorForParameterName, int queryPersonId);

	public void insertAll(String queryParameterName, int queryPersonId, List<Number> numericalValues, List<Object> alphanumerialValues);
}
