package fr.ifremer.adagio.core.dao.referential.taxon;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.StatusCode;
import fr.ifremer.adagio.core.dao.referential.StatusImpl;
import fr.ifremer.adagio.core.dao.technical.hibernate.TemporaryDataHelper;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.hibernate.type.StringType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

/**
 * @see fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup
 */
@Repository("taxonGroupDao")
@Lazy
public class TaxonGroupDaoImpl extends TaxonGroupDaoBase implements TaxonGroupExtendDao {

	/**
	 * Constructor used by Spring
	 */
	@Autowired
	public TaxonGroupDaoImpl(SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public TaxonGroup createAsTemporary(String label, String name, String taxonGroupTypeCode, String comments) {
		Integer taxonGroupId = TemporaryDataHelper.getNewNegativeIdForTemporaryData(getSession(), TaxonGroupImpl.class);

		// Compute a temporary label is not filled
		if (StringUtils.isBlank(label)) {
			label = TemporaryDataHelper.getTemporaryLabelFromNegativeId(taxonGroupId);
		}

		// Fill the adagion entity
		TaxonGroup target = TaxonGroup.Factory.newInstance();
		target.setId(taxonGroupId);
		target.setLabel(label);
		target.setName(name);
		target.setComments(comments);
		target.setTaxonGroupType((TaxonGroupType) load(TaxonGroupTypeImpl.class, taxonGroupTypeCode));
		target.setStatus((Status) load(StatusImpl.class, StatusCode.TEMPORARY.getValue()));
		target.setIsChildGroupExclusive(false);
		target.setIsUpdatable(false);
		target.setCreationDate(new Date());

		target = create(target);

		return target;
	}
}
