package fr.ifremer.adagio.core.dao.referential.pmfm;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.technical.AdagioEnumerationDef;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import static org.nuiton.i18n.I18n.n;

/**
 * Created on 4/24/14.
 * 
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 3.5
 * @deprecated Use fr.ifremer.adagio.core.dao.referential.ObjectTypeCode instead
 */
public enum ObjectTypeCode2 implements Serializable, AdagioEnumerationDef<String> {
	/** TODO: Model Documentation for Enumeration Literal ACTIVITY_CALENDAR value "ACTIVITY_CALENDAR" */
	ACTIVITY_CALENDAR(
			"adagio.enumeration.ObjectTypeCode.ACTIVITY_CALENDAR",
			n("adagio.enumeration.ObjectTypeCode.ACTIVITY_CALENDAR.description"),
			"ACTIVITY_CALENDAR"),
	/** TODO: Model Documentation for Enumeration Literal FISHING_TRIP value "FISHING_TRIP" */
	FISHING_TRIP(
			"adagio.enumeration.ObjectTypeCode.FISHING_TRIP",
			n("adagio.enumeration.ObjectTypeCode.FISHING_TRIP.description"),
			"FISHING_TRIP"),
	/** TODO: Model Documentation for Enumeration Literal OPERATION value "OPERATION" */
	OPERATION(
			"adagio.enumeration.ObjectTypeCode.OPERATION",
			n("adagio.enumeration.ObjectTypeCode.OPERATION.description"),
			"OPERATION"),
	/** TODO: Model Documentation for Enumeration Literal BATCH value "BATCH" */
	CATCH_BATCH(
			"adagio.enumeration.ObjectTypeCode.CATCH_BATCH",
			n("adagio.enumeration.ObjectTypeCode.CATCH_BATCH.description"),
			"CATCH_BATCH"),
	/** TODO: Model Documentation for Enumeration Literal BATCH value "BATCH" */
	BATCH(
			"adagio.enumeration.ObjectTypeCode.BATCH",
			n("adagio.enumeration.ObjectTypeCode.BATCH.description"),
			"BATCH"),
	/** TODO: Model Documentation for Enumeration Literal SAMPLE value "SAMPLE" */
	SAMPLE(
			"adagio.enumeration.ObjectTypeCode.SAMPLE",
			n("adagio.enumeration.ObjectTypeCode.SAMPLE.description"),
			"SAMPLE"),
	/** TODO: Model Documentation for Enumeration Literal SCIENTIFIC_CRUISE value "SCIENTIFIC_CRUISE" */
	SCIENTIFIC_CRUISE(
			"adagio.enumeration.ObjectTypeCode.SCIENTIFIC_CRUISE",
			n("adagio.enumeration.ObjectTypeCode.SCIENTIFIC_CRUISE.description"),
			"SCIENTIFIC_CRUISE"),
	/** TODO: Model Documentation for Enumeration Literal SALE value "SALE" */
	SALE(
			"adagio.enumeration.ObjectTypeCode.SALE",
			n("adagio.enumeration.ObjectTypeCode.SALE.description"),
			"SALE"),
	/** TODO: Model Documentation for Enumeration Literal LANDING value "LANDING" */
	LANDING(
			"adagio.enumeration.ObjectTypeCode.LANDING",
			n("adagio.enumeration.ObjectTypeCode.LANDING.description"),
			"LANDING"),
	/** TODO: Model Documentation for Enumeration Literal DAILY_ACTIVITY_CALENDAR value "DAILY_ACTIVITY_CALENDAR" */
	DAILY_ACTIVITY_CALENDAR(
			"adagio.enumeration.ObjectTypeCode.DAILY_ACTIVITY_CALENDAR",
			n("adagio.enumeration.ObjectTypeCode.DAILY_ACTIVITY_CALENDAR.description"),
			"DAILY_ACTIVITY_CALENDAR");

	/**
	 * The serial version UID of this class. Needed for serialization.
	 */
	private static final long serialVersionUID = -8263283045204115976L;

	private String key;

	private String description;

	private String enumValue;

	private ObjectTypeCode2(String key, String description, String value) {
		this.key = key;
		this.description = description;
		this.enumValue = value;
	}

	@Override
	public void setValue(String newValue) {
		if (newValue != null && !this.enumValue.equals(newValue)) {
			// Update static lists
			values.remove(this.enumValue);
			literals.remove(this.enumValue);
			this.enumValue = newValue;
			values.put(this.enumValue, this);
			literals.add(this.enumValue);
		}
	}

	@Override
	public String getValueAsString() {
		return String.valueOf(this.enumValue);
	}

	/**
	 * Retrieves an instance of ObjectTypeCode2 from <code>its name</code>.
	 * 
	 * @param name
	 *            the name to create the ObjectTypeCode2 from.
	 * @return The enumeration literal named after the 'name' argument
	 */
	public static ObjectTypeCode2 fromString(String name) {
		return ObjectTypeCode2.valueOf(name);
	}

	/**
	 * Returns an enumeration literal String <code>value</code>.
	 * Required by JAXB2 enumeration implementation
	 * 
	 * @return String with corresponding value
	 */
	public String value() {
		return this.enumValue;
	}

	/**
	 * Returns an instance of ObjectTypeCode2 from String <code>value</code>.
	 * Required by JAXB2 enumeration implementation
	 * 
	 * @param value
	 *            the value to create the ObjectTypeCode2 from.
	 * @return static Enumeration with corresponding value
	 */
	public static ObjectTypeCode2 fromValue(String value) {
		for (ObjectTypeCode2 enumName : ObjectTypeCode2.values()) {
			if (enumName.getValue().equals(value)) {
				return enumName;
			}
		}
		throw new IllegalArgumentException("ObjectTypeCode2.fromValue(" + value + ')');
	}

	/**
	 * Gets the underlying value of this type safe enumeration.
	 * This method is necessary to comply with DaoBase implementation.
	 * 
	 * @return The name of this literal.
	 */
	public String getValue() {
		return this.enumValue;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public Class<?> getType() {
		return String.class;
	}

	/**
	 * Returns an unmodifiable list containing the literals that are known by this enumeration.
	 * 
	 * @return A List containing the actual literals defined by this enumeration, this list
	 *         can not be modified.
	 */
	public static List<String> literals() {
		return ObjectTypeCode2.literals;
	}

	/**
	 * Returns an unmodifiable list containing the names of the literals that are known
	 * by this enumeration.
	 * 
	 * @return A List containing the actual names of the literals defined by this
	 *         enumeration, this list can not be modified.
	 */
	public static List<String> names() {
		return ObjectTypeCode2.names;
	}

	private static Map<String, ObjectTypeCode2> values = new LinkedHashMap<String, ObjectTypeCode2>(9, 1);

	private static List<String> literals = new ArrayList<String>(9);

	private static List<String> names = new ArrayList<String>(9);

	private static List<ObjectTypeCode2> valueList = new ArrayList<ObjectTypeCode2>(9);

	/**
	 * Initializes the values.
	 */
	static {
		synchronized (ObjectTypeCode2.values) {
			ObjectTypeCode2.values.put(ACTIVITY_CALENDAR.enumValue, ACTIVITY_CALENDAR);
			ObjectTypeCode2.values.put(FISHING_TRIP.enumValue, FISHING_TRIP);
			ObjectTypeCode2.values.put(OPERATION.enumValue, OPERATION);
			ObjectTypeCode2.values.put(BATCH.enumValue, BATCH);
			ObjectTypeCode2.values.put(SAMPLE.enumValue, SAMPLE);
			ObjectTypeCode2.values.put(SCIENTIFIC_CRUISE.enumValue, SCIENTIFIC_CRUISE);
			ObjectTypeCode2.values.put(SALE.enumValue, SALE);
			ObjectTypeCode2.values.put(LANDING.enumValue, LANDING);
			ObjectTypeCode2.values.put(DAILY_ACTIVITY_CALENDAR.enumValue, DAILY_ACTIVITY_CALENDAR);
		}
		synchronized (ObjectTypeCode2.valueList) {
			ObjectTypeCode2.valueList.add(ACTIVITY_CALENDAR);
			ObjectTypeCode2.valueList.add(FISHING_TRIP);
			ObjectTypeCode2.valueList.add(OPERATION);
			ObjectTypeCode2.valueList.add(BATCH);
			ObjectTypeCode2.valueList.add(SAMPLE);
			ObjectTypeCode2.valueList.add(SCIENTIFIC_CRUISE);
			ObjectTypeCode2.valueList.add(SALE);
			ObjectTypeCode2.valueList.add(LANDING);
			ObjectTypeCode2.valueList.add(DAILY_ACTIVITY_CALENDAR);
			// For Adagio, lists could be reload from configuration
			// ObjectTypeCode2.valueList = Collections.unmodifiableList(valueList);
		}
		synchronized (ObjectTypeCode2.literals) {
			ObjectTypeCode2.literals.add(ACTIVITY_CALENDAR.enumValue);
			ObjectTypeCode2.literals.add(FISHING_TRIP.enumValue);
			ObjectTypeCode2.literals.add(OPERATION.enumValue);
			ObjectTypeCode2.literals.add(BATCH.enumValue);
			ObjectTypeCode2.literals.add(SAMPLE.enumValue);
			ObjectTypeCode2.literals.add(SCIENTIFIC_CRUISE.enumValue);
			ObjectTypeCode2.literals.add(SALE.enumValue);
			ObjectTypeCode2.literals.add(LANDING.enumValue);
			ObjectTypeCode2.literals.add(DAILY_ACTIVITY_CALENDAR.enumValue);
			// For Adagio, lists could be reload from configuration
			// ObjectTypeCode2.literals = Collections.unmodifiableList(literals);
		}
		synchronized (ObjectTypeCode2.names) {
			ObjectTypeCode2.names.add("ACTIVITY_CALENDAR");
			ObjectTypeCode2.names.add("FISHING_TRIP");
			ObjectTypeCode2.names.add("OPERATION");
			ObjectTypeCode2.names.add("BATCH");
			ObjectTypeCode2.names.add("SAMPLE");
			ObjectTypeCode2.names.add("SCIENTIFIC_CRUISE");
			ObjectTypeCode2.names.add("SALE");
			ObjectTypeCode2.names.add("LANDING");
			ObjectTypeCode2.names.add("DAILY_ACTIVITY_CALENDAR");
			ObjectTypeCode2.names = Collections.unmodifiableList(names);
		}
	}
	// type-safe-enumeration-object java merge-point
}