/*
 * #%L
 * SIH-Adagio
 * $Id: MatrixId2.java 1725 2014-04-24 10:17:09Z tchemit $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/trunk/adagio/mda/src/main/config/javaMergeMappings.xml $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.adagio.core.dao.referential.pmfm;

import fr.ifremer.adagio.core.dao.technical.AdagioEnumerationDef;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import static org.nuiton.i18n.I18n.n;

/**
 * @deprecated Use fr.ifremer.adagio.core.dao.referential.pmfm.MatrixId instead
 */
public enum MatrixId2
		implements Serializable, AdagioEnumerationDef<Integer> {
	/** TODO: Model Documentation for Enumeration Literal PRODUCT_BATCH value 1 */
	PRODUCT_BATCH(
			"adagio.enumeration.MatrixId.PRODUCT_BATCH",
			n("adagio.enumeration.MatrixId.PRODUCT_BATCH.description"),
			1);

	/**
	 * The serial version UID of this class. Needed for serialization.
	 */
	private static final long serialVersionUID = 1L;

	private String key;

	private String description;

	private Integer enumValue;

	private MatrixId2(String key, String description, Integer value) {
		this.key = key;
		this.description = description;
		this.enumValue = value;
	}

	@Override
	public void setValue(Integer newValue) {
		if (newValue != null && !this.enumValue.equals(newValue)) {
			// Update static lists
			values.remove(this.enumValue);
			literals.remove(this.enumValue);
			this.enumValue = newValue;
			values.put(this.enumValue, this);
			literals.add(this.enumValue);
		}
	}

	@Override
	public String getValueAsString() {
		return String.valueOf(this.enumValue);
	}

	/**
	 * Retrieves an instance of MatrixId from <code>its name</code>.
	 * 
	 * @param name
	 *            the name to create the MatrixId from.
	 * @return The enumeration literal named after the 'name' argument
	 */
	public static MatrixId2 fromString(String name) {
		return MatrixId2.valueOf(name);
	}

	/**
	 * Returns an enumeration literal Integer <code>value</code>.
	 * Required by JAXB2 enumeration implementation
	 * 
	 * @return Integer with corresponding value
	 */
	public Integer value() {
		return this.enumValue;
	}

	/**
	 * Returns an instance of MatrixId from Integer <code>value</code>.
	 * Required by JAXB2 enumeration implementation
	 * 
	 * @param value
	 *            the value to create the MatrixId from.
	 * @return static Enumeration with corresponding value
	 */
	public static MatrixId2 fromValue(Integer value) {
		for (MatrixId2 enumName : MatrixId2.values()) {
			if (enumName.getValue().equals(value)) {
				return enumName;
			}
		}
		throw new IllegalArgumentException("MatrixId.fromValue(" + value.toString() + ')');
	}

	/**
	 * Gets the underlying value of this type safe enumeration.
	 * This method is necessary to comply with DaoBase implementation.
	 * 
	 * @return The name of this literal.
	 */
	public Integer getValue() {
		return this.enumValue;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public Class<?> getType() {
		return Integer.class;
	}

	/**
	 * Returns an unmodifiable list containing the literals that are known by this enumeration.
	 * 
	 * @return A List containing the actual literals defined by this enumeration, this list
	 *         can not be modified.
	 */
	public static List<Integer> literals() {
		return MatrixId2.literals;
	}

	/**
	 * Returns an unmodifiable list containing the names of the literals that are known
	 * by this enumeration.
	 * 
	 * @return A List containing the actual names of the literals defined by this
	 *         enumeration, this list can not be modified.
	 */
	public static List<String> names() {
		return MatrixId2.names;
	}

	private static Map<Integer, MatrixId2> values = new LinkedHashMap<Integer, MatrixId2>(4, 1);

	private static List<Integer> literals = new ArrayList<Integer>(4);

	private static List<String> names = new ArrayList<String>(4);

	private static List<MatrixId2> valueList = new ArrayList<MatrixId2>(4);

	/**
	 * Initializes the values.
	 */
	static {
		synchronized (MatrixId2.values) {
			MatrixId2.values.put(PRODUCT_BATCH.enumValue, PRODUCT_BATCH);
		}
		synchronized (MatrixId2.valueList) {
			MatrixId2.valueList.add(PRODUCT_BATCH);
			// For Adagio, lists could be reload from configuration
			// MatrixId.valueList = Collections.unmodifiableList(valueList);
		}
		synchronized (MatrixId2.literals) {
			MatrixId2.literals.add(PRODUCT_BATCH.enumValue);
			// For Adagio, lists could be reload from configuration
			// MatrixId.literals = Collections.unmodifiableList(literals);
		}
		synchronized (MatrixId2.names) {
			MatrixId2.names.add("PRODUCT_BATCH");
			MatrixId2.names = Collections.unmodifiableList(names);
		}
	}
}