// Generated by: hibernate/SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.metier;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.StatusCode;
import fr.ifremer.adagio.core.dao.referential.StatusImpl;
import fr.ifremer.adagio.core.dao.referential.gear.GearDao;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupDao;
import fr.ifremer.adagio.core.dao.technical.hibernate.TemporaryDataHelper;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

/**
 * @see fr.ifremer.adagio.core.dao.referential.metier.Metier
 */
@Repository("metierDao")
@Lazy
public class MetierDaoImpl extends MetierDaoBase implements MetierExtendDao
{
	@Autowired
	private TaxonGroupDao taxonGroupDao;

	@Autowired
	private GearDao gearDao;

	/**
	 * Constructor used by Spring
	 */
	@Autowired
	public MetierDaoImpl(SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public Metier createAsTemporary(String label, String name, Integer taxonGroupId, Integer gearId) {
		Integer metierId = TemporaryDataHelper.getNewNegativeIdForTemporaryData(getSession(), MetierImpl.class);

		// Compute a temporary label is not filled
		if (StringUtils.isBlank(label)) {
			label = TemporaryDataHelper.getTemporaryLabelFromNegativeId(metierId);
		}

		// Fill the adagio entity
		Metier target = Metier.Factory.newInstance();
		target.setId(metierId);
		target.setLabel(label);
		target.setName(name);
		target.setStatus((Status) load(StatusImpl.class, StatusCode.TEMPORARY.getValue()));

		// Load taxonGroup
		if (taxonGroupId != null) {
			target.setTaxonGroup(taxonGroupDao.get(taxonGroupId));
		}

		// Load gear
		if (gearId != null) {
			target.setGear(gearDao.get(gearId));
		}

		// Create the entity
		target = create(target);
		return target;
	}

}