package fr.ifremer.adagio.core.dao.data.vessel.feature.physical;

/*
 * #%L
 * Tutti :: Persistence API
 * $Id: GearPhysicalFeaturesDaoImpl.java 12131 2014-06-09 15:42:57Z bl05b3e $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.8.2/core-allegro/src/main/java/fr/ifremer/adagio/core/dao/data/vessel/feature/physical/GearPhysicalFeaturesDaoImpl.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Collection;
import java.util.Date;
import java.util.List;

import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import fr.ifremer.adagio.core.dao.administration.user.DepartmentImpl;
import fr.ifremer.adagio.core.dao.data.measure.GearPhysicalMeasurement;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.scientificCruise.ScientificCruise;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.gear.Gear;
import fr.ifremer.adagio.core.dao.referential.gear.GearImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueImpl;

@Repository("gearPhysicalFeaturesDao")
@Lazy
public class GearPhysicalFeaturesDaoImpl
		extends GearPhysicalFeaturesDaoBase
		implements GearPhysicalFeaturesExtendDao {

	/**
	 * Constructor used by Spring
	 */
	@Autowired
	public GearPhysicalFeaturesDaoImpl(org.hibernate.SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public GearPhysicalFeatures getGearPhysicalfeatures(FishingTrip fishingTrip, Integer gearId) {
		return getGearPhysicalfeatures(fishingTrip, gearId, false);
	}

	@Override
	public GearPhysicalFeatures getGearPhysicalfeatures(FishingTrip fishingTrip, Integer gearId, boolean createIfNotExists) {
		// Retrieve entities : Gear Physical Features
		if (fishingTrip.getGearPhysicalFeatures() != null && fishingTrip.getGearPhysicalFeatures().size() >= 0) {
			for (GearPhysicalFeatures guf : fishingTrip.getGearPhysicalFeatures()) {
				if (gearId.equals(guf.getGear().getId())) {
					return guf;
				}
			}
		}
		if (!createIfNotExists) {
			return null;
		}

		return newGearPhysicalfeatures(fishingTrip, gearId);

	}

	@Override
	public GearPhysicalFeatures newGearPhysicalfeatures(FishingTrip fishingTrip, Integer gearId) {
		GearPhysicalFeatures guf = GearPhysicalFeatures.Factory.newInstance();
		guf.setFishingTrip(fishingTrip);

		Gear gear = load(GearImpl.class, gearId);
		guf.setGear(gear);
		if (fishingTrip.getGearPhysicalFeatures() == null) {
			fishingTrip.setGearPhysicalFeatures(Lists.newArrayList(guf));
		} else {
			fishingTrip.getGearPhysicalFeatures().add(guf);
		}

		// Set default attributes (copy from fishing trip)
		guf.setStartDate(fishingTrip.getDepartureDateTime());
		guf.setEndDate(fishingTrip.getReturnDateTime());
		guf.setProgram(fishingTrip.getProgram());
		guf.setCreationDate(new Date());
		guf.setQualityFlag(load(QualityFlagImpl.class, QualityFlagCode.NOTQUALIFIED.getValue()));
		guf.setRankOrder((short) 1);
		guf.setVessel(fishingTrip.getVessel());

		return guf;
	}

	@Override
	public GearPhysicalMeasurement getGearPhysicalMeasurement(GearPhysicalFeatures gearPhysicalFeatures, Integer pmfmId) {
		return getGearPhysicalMeasurement(gearPhysicalFeatures, pmfmId, false);
	}

	protected GearPhysicalMeasurement getGearPhysicalMeasurement(GearPhysicalFeatures gearPhysicalFeatures,
			Integer pmfmId, boolean createIfNotExists) {
		GearPhysicalMeasurement gearPhysicalMeasurement = null;
		if (gearPhysicalFeatures.getGearPhysicalMeasurements() != null) {
			for (GearPhysicalMeasurement vum : gearPhysicalFeatures.getGearPhysicalMeasurements()) {
				if (pmfmId.equals(vum.getPmfm().getId())) {
					gearPhysicalMeasurement = vum;
					break;
				}
			}
		}
		if (gearPhysicalMeasurement != null || !createIfNotExists) {
			return gearPhysicalMeasurement;
		}

		gearPhysicalMeasurement = GearPhysicalMeasurement.Factory.newInstance();
		gearPhysicalMeasurement.setGearPhysicalFeatures(gearPhysicalFeatures);
		if (gearPhysicalFeatures.getGearPhysicalMeasurements() == null) {
			gearPhysicalFeatures.setGearPhysicalMeasurements(Sets.newHashSet(gearPhysicalMeasurement));
		} else {
			gearPhysicalFeatures.getGearPhysicalMeasurements().add(gearPhysicalMeasurement);
		}
		gearPhysicalMeasurement.setQualityFlag(load(QualityFlagImpl.class, QualityFlagCode.NOTQUALIFIED.getValue()));
		Pmfm pmfm = load(PmfmImpl.class, pmfmId);
		gearPhysicalMeasurement.setPmfm(pmfm);

		return gearPhysicalMeasurement;
	}

	@Override
	public void removeGearPhysicalMeasurement(GearPhysicalFeatures gearPhysicalFeatures,
			Integer pmfmId) {
		GearPhysicalMeasurement gearPhysicalMeasurement = getGearPhysicalMeasurement(gearPhysicalFeatures, pmfmId, false);
		if (gearPhysicalMeasurement == null) {
			return;
		}
		gearPhysicalFeatures.getGearPhysicalMeasurements().remove(gearPhysicalMeasurement);
		// TOBO BLa : vérifier qu'il ne faut pas dao.delete() en plus
	}

	@Override
	public GearPhysicalMeasurement setGearPhysicalMeasurement(GearPhysicalFeatures gearPhysicalFeatures,
			Integer pmfmId,
			Float numericalValue,
			String alphanumericalValue,
			Integer qualitativevalueId,
			Integer recorderDepartmentId) {
		GearPhysicalMeasurement gearPhysicalMeasurement = getGearPhysicalMeasurement(gearPhysicalFeatures, pmfmId, true);

		if (alphanumericalValue != null) {
			gearPhysicalMeasurement.setAlphanumericalValue(alphanumericalValue);
		} else if (numericalValue != null) {
			gearPhysicalMeasurement.setNumericalValue(numericalValue);
		} else if (qualitativevalueId != null) {
			QualitativeValue qv = load(QualitativeValueImpl.class, qualitativevalueId);
			gearPhysicalMeasurement.setQualitativeValue(qv);
		}

		if (recorderDepartmentId != null) {
			gearPhysicalMeasurement.setDepartment(load(DepartmentImpl.class, recorderDepartmentId));
		}

		return gearPhysicalMeasurement;
	}

	@Override
	public GearPhysicalMeasurement setGearPhysicalMeasurement(ScientificCruise scientificCruise, GearPhysicalFeatures gearPhysicalFeatures,
			Integer pmfmId,
			Float numericalValue,
			String alphanumericalValue,
			Integer qualitativevalueId) {

		Integer recorderDepartmentId = null;
		if (scientificCruise != null && scientificCruise.getRecorderDepartment() != null) {
			recorderDepartmentId = scientificCruise.getRecorderDepartment().getId();
		}
		return setGearPhysicalMeasurement(gearPhysicalFeatures, pmfmId, numericalValue, alphanumericalValue, qualitativevalueId, recorderDepartmentId);
	}

	@Override
	public void remove(Collection<GearPhysicalFeatures> entities) {
		if (entities == null) {
			throw new IllegalArgumentException(
					"GearPhysicalFeatures.remove - 'entities' can not be null");
		}
		if (entities.size() == 0) {
			return;
		}

		List<Integer> ids = Lists.newArrayList();
		for (GearPhysicalFeatures entity : entities) {
			ids.add(entity.getId());
		}

		// Call method removeByIds (faster than method remove(GearPhysicalFeatures) )
		removeByIds(ids);
	}

	@Override
	public void remove(GearPhysicalFeatures entity) {
		if (CollectionUtils.isNotEmpty(entity.getGearPhysicalMeasurements())) {
			entity.getGearPhysicalMeasurements().clear();
		}
		if (CollectionUtils.isNotEmpty(entity.getGearPhysicalFeaturesOrigins())) {
			entity.getGearPhysicalFeaturesOrigins().clear();
		}
		if (CollectionUtils.isNotEmpty(entity.getOperations())) {
			entity.getOperations().clear();
		}
		super.remove(entity);
	}

	@Override
	public void remove(Integer id) {
		removeByIds(Lists.newArrayList(id));
	}

	@Override
	public void removeByIds(Collection<Integer> ids) {
		Query query = createQuery("deleteGearPhysicalMeasurementByFeatures");
		query.setParameterList("gearPhysicalFeaturesIds", ids);
		query.executeUpdate();

		query = createQuery("removeOperationGearPhysicalFeatures");
		query.setParameterList("gearPhysicalFeaturesIds", ids);
		query.executeUpdate();

		query = createQuery("deleteGearPhysicalFeatures");
		query.setParameterList("gearPhysicalFeaturesIds", ids);
		query.executeUpdate();

		// TODO : delete gearPhysicalFeaturesOrigins also
	}
}
