package fr.ifremer.adagio.core.dao.data.vessel;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: VesselExtendDao.java 12554 2015-01-12 13:16:58Z tc1fbb1 $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.8.2/core-allegro/src/main/java/fr/ifremer/adagio/core/dao/data/vessel/VesselExtendDao.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Date;

public interface VesselExtendDao extends VesselDao {

	/**
	 * Create a temporary vessel. Denormalized vessel are not update in this method.
	 * 
	 * @param nationalRegistrationCode
	 * @param internationalRegistrationCode
	 * @param registrationLocationId
	 * @param name
	 * @param vesselTypeId
	 * @return
	 * @deprecated use the second method instead (with argument 'refreshDenormalizedVessel')
	 */
	Vessel createAsTemporary(String nationalRegistrationCode,
			String internationalRegistrationCode,
			Integer registrationLocationId,
			String name,
			Integer vesselTypeId);

	/**
	 * Create a temporary vessel
	 * 
	 * @param nationalRegistrationCode
	 * @param internationalRegistrationCode
	 * @param registrationLocationId
	 * @param name
	 * @param vesselTypeId
	 * @param refreshDenormalizedVessel
	 *            need to refresh denormalized vessel table ?
	 * @return The created Vessel entity
	 */
	Vessel createAsTemporary(String nationalRegistrationCode,
			String internationalRegistrationCode,
			Integer registrationLocationId,
			String name,
			Integer vesselTypeId,
			boolean refreshDenormalizedVessel);

	/**
	 * Update a temporary vessel.
	 * 
	 * @param nationalRegistrationCode
	 * @param internationalRegistrationCode
	 * @param registrationLocationId
	 * @param name
	 * @param vesselTypeId
	 * @param refreshDenormalizedVessel
	 *            need to refresh denormalized vessel table ?
	 * @return The updated Vessel entity
	 */
	Vessel updateTemporaryVessel(String vesselCode,
			String nationalRegistrationCode,
			String internationalRegistrationCode,
			Integer registrationLocationId,
			String name,
			Integer vesselTypeId,
			boolean refreshDenormalizedVessel);

	/**
	 * Refresh DenormalizedVessel entries for some programs
	 * 
	 * @param programCodes
	 *            list of vessel's program to refresh
	 */
	void refreshAllDenormalizedVessels(String[] programCodes, Date refDate);

	/**
	 * Refresh DenormalizedVessel entries for some programs
	 * 
	 * @param programCodes
	 *            list of vessel's program to refresh
	 * @param vesselCodes
	 *            a list of vessel codes to refresh
	 */
	void refreshDenormalizedVessels(String[] programCodes, Date refDate, String[] vesselCodes);

	/**
	 * Remove a temporary vessel.
	 * 
	 * @param vesselCode
	 *            the code of vessel to remove
	 * @since 3.6.4
	 */
	void removeTemporaryVessel(String vesselCode);

}
