// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.vessel;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: VesselDaoImpl.java 12554 2015-01-12 13:16:58Z tc1fbb1 $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.8.2/core-allegro/src/main/java/fr/ifremer/adagio/core/dao/data/vessel/VesselDaoImpl.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Date;
import java.util.TreeSet;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.type.StringType;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataRetrievalFailureException;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;

import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.programStrategy.ProgramCode;
import fr.ifremer.adagio.core.dao.administration.programStrategy.ProgramImpl;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.VesselFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.VesselFeaturesDao;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.VesselFeaturesImpl;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.StatusCode;
import fr.ifremer.adagio.core.dao.referential.StatusImpl;
import fr.ifremer.adagio.core.dao.referential.VesselType;
import fr.ifremer.adagio.core.dao.referential.VesselTypeImpl;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.location.LocationExtendDao;
import fr.ifremer.adagio.core.dao.referential.location.LocationImpl;
import fr.ifremer.adagio.core.dao.referential.location.LocationLevelId;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import fr.ifremer.adagio.core.dao.technical.hibernate.TemporaryDataHelper;
import fr.ifremer.adagio.core.dao.technical.optimization.vessel.DenormalizedVessel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.type.StringType;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataRetrievalFailureException;

import javax.annotation.Resource;
import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Collection;
import java.util.Date;
import java.util.TreeSet;

/**
 * @see fr.ifremer.adagio.core.dao.data.vessel.Vessel
 */
@org.springframework.stereotype.Repository("vesselExtendDao")
@org.springframework.context.annotation.Lazy
public class VesselDaoImpl
		extends fr.ifremer.adagio.core.dao.data.vessel.VesselDaoBase
		implements VesselExtendDao {

	/** Logger. */
	private static final Log log =
			LogFactory.getLog(VesselDaoImpl.class);

	@Resource(name = "vesselFeaturesDao")
	protected VesselFeaturesDao vesselFeaturesDao;

	@Resource(name = "vesselRegistrationPeriodDao")
	protected VesselRegistrationPeriodDao vesselRegistrationPeriodDao;

	@Autowired
	protected LocationExtendDao locationDao;

	@Resource(name = "dataSource")
	protected DataSource dataSource;

	/**
	 * Constructor used by Spring
	 */
	@org.springframework.beans.factory.annotation.Autowired
	public VesselDaoImpl(org.hibernate.SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public Vessel createAsTemporary(String nationalRegistrationCode, String internationalRegistrationCode, Integer registrationLocationId,
			String name, Integer vesselTypeId) {
		return createAsTemporary(nationalRegistrationCode, internationalRegistrationCode, registrationLocationId, name, vesselTypeId,
				false /* do not update denormalized vessel */);
	}

	@Override
	public Vessel createAsTemporary(String nationalRegistrationCode, String internationalRegistrationCode, Integer registrationLocationId,
			String name, Integer vesselTypeId, boolean refreshDenormalizedVessel) {
		if (log.isDebugEnabled()) {
			log.debug("Create a new temporary vessel");
		}
		Vessel target = Vessel.Factory.newInstance();

		// Compute a new vessel code
		String vesselCode = nationalRegistrationCode;
		if (vesselCode == null) {
			vesselCode = internationalRegistrationCode;
		}
		if (vesselCode == null) {
			vesselCode = name;
		}
		// Find a safe vessel code (increment if need)
		vesselCode = getUnusedTemporaryVesselCode(vesselCode);
		target.setCode(vesselCode);

		// Save to entity
		saveOrUpdateTemporaryVessel(target, nationalRegistrationCode, internationalRegistrationCode, registrationLocationId, name, vesselTypeId,
				refreshDenormalizedVessel);

		return target;
	}

	@Override
	public Vessel updateTemporaryVessel(String vesselCode, String nationalRegistrationCode, String internationalRegistrationCode,
			Integer registrationLocationId, String name, Integer vesselTypeId, boolean refreshDenormalizedVessel) {
		Preconditions.checkNotNull(vesselCode);

		if (log.isDebugEnabled()) {
			log.debug(String.format("Update temporary vessel with code='%s'", vesselCode));
		}

		// Add prefix is not present
		if (vesselCode.startsWith(TemporaryDataHelper.TEMPORARY_NAME_PREFIX) == false) {
			vesselCode = TemporaryDataHelper.TEMPORARY_NAME_PREFIX + vesselCode;
		}

		Vessel target = load(vesselCode);
		if (target == null) {
			throw new DataRetrievalFailureException("Could not load temporary vessel with code: " + vesselCode);
		}

		// Save to entity
		saveOrUpdateTemporaryVessel(target, nationalRegistrationCode, internationalRegistrationCode, registrationLocationId, name, vesselTypeId,
				refreshDenormalizedVessel);

		return target;
	}

	@Override
	public void refreshAllDenormalizedVessels(String[] programCodes, Date refDate) {
		refreshAllDenormalizedVesselsJdbc(programCodes, refDate, null);
	}

	@Override
	public void refreshDenormalizedVessels(String[] programCodes, Date refDate, String[] vesselCodes) {
		refreshAllDenormalizedVesselsJdbc(programCodes, refDate, vesselCodes);
	}

	/* -- Internal methods -- */

	@Override
	public void removeTemporaryVessel(String vesselCode) {

		// TODO check that vessel code is a temporary one

		Vessel vesselToRemove = load(VesselImpl.class, vesselCode);

		if (vesselToRemove == null) {
			throw new IllegalArgumentException("Could not find a vessel with code: " + vesselCode);
		}

		Collection<VesselRegistrationPeriod> vesselRegistrationPeriods = vesselToRemove.getVesselRegistrationPeriods();
		if (vesselRegistrationPeriods != null) {

			// remove vessel registration periods
			vesselRegistrationPeriods.clear();
		}

		Collection<VesselFeatures> vesselFeatures = vesselToRemove.getVesselFeatures();
		if (vesselFeatures != null) {

			// vesselFeatures ownes the relation to vessel
			vesselFeaturesDao.remove(vesselFeatures);

			// remove vessel features
			vesselFeatures.clear();
		}

		// Remove denormalized vessel
		if (log.isDebugEnabled()) {
			log.debug("Refresh denormalizedVessel for this vessel");
		}

		int rowCount = queryUpdate("deleteDenormalizedVessels",
				"vesselCodes", StringType.INSTANCE, vesselToRemove.getCode(),
				"programCodes", StringType.INSTANCE, ProgramCode.SIH.getValue());
		if (log.isDebugEnabled()) {
			log.debug(String.format(" %s rows deleted", rowCount));
		}

		// getSession().setFlushMode(FlushMode.COMMIT);
		// getSession().flush();

		remove(vesselToRemove);

	}

	/* -- Internal methods -- */

	protected void saveOrUpdateTemporaryVessel(Vessel target, String nationalRegistrationCode, String internationalRegistrationCode,
			Integer registrationLocationId,
			String name, Integer vesselTypeId, boolean refreshDenormalizedVessel) {
		Session session = getSession();

		target.setVesselType((VesselType) load(VesselTypeImpl.class, vesselTypeId));
		target.setStatus((Status) load(StatusImpl.class, StatusCode.TEMPORARY.getValue()));
		// Use 'SIH' program to create new vessel, by default
		target.setProgram((Program) load(ProgramImpl.class, ProgramCode.SIH.getValue()));
		session.save(target);

		// Vessel registration period
		VesselRegistrationPeriod vrp = null;
		VesselRegistrationPeriodPK vrpPK = null;
		if (CollectionUtils.isEmpty(target.getVesselRegistrationPeriods())) {
			vrp = VesselRegistrationPeriod.Factory.newInstance();
			vrpPK = new VesselRegistrationPeriodPK();
			vrpPK.setStartDateTime(new Date(0));
			vrpPK.setVessel((VesselImpl) target);
			vrpPK.setRegistrationLocation((LocationImpl) load(LocationImpl.class, registrationLocationId));
			vrp.setVesselRegistrationPeriodPk(vrpPK);
			target.getVesselRegistrationPeriods().add(vrp);
		} else {
			vrp = CollectionUtils.extractSingleton(target.getVesselRegistrationPeriods());
			vrpPK = vrp.getVesselRegistrationPeriodPk();
			if (vrpPK.getRegistrationLocation().getId().intValue() != registrationLocationId) {
				vesselRegistrationPeriodDao.remove(vrpPK);
				vrpPK.setRegistrationLocation((LocationImpl) load(LocationImpl.class, registrationLocationId));
				vrp.setVesselRegistrationPeriodPk(vrpPK);
				target.setVesselRegistrationPeriods(Sets.newHashSet(vrp));
			}
		}
		vrp.setRegistrationCode(nationalRegistrationCode);
		vrp.setInternationalRegistrationCode(internationalRegistrationCode);
		vrp.setRankOrder((short) 1);
		vrp.setQualityFlag((QualityFlag) load(QualityFlagImpl.class, QualityFlagCode.NOTQUALIFIED.getValue()));
		session.save(vrp);

		// Vessel features (for name)
		VesselFeatures vesselFeatures = null;
		if (CollectionUtils.isEmpty(target.getVesselFeatures())) {
			vesselFeatures = VesselFeatures.Factory.newInstance();
			Integer vesselFeaturesId = TemporaryDataHelper.getNewNegativeIdForTemporaryData(session, VesselFeaturesImpl.class);
			vesselFeatures.setId(vesselFeaturesId);
			target.getVesselFeatures().add(vesselFeatures);
		} else {
			vesselFeatures = CollectionUtils.extractSingleton(target.getVesselFeatures());
		}
		vesselFeatures.setStartDateTime(new Date(0));
		vesselFeatures.setName(name);
		vesselFeatures.setIsFPC(false); // mandatory field
		vesselFeatures.setVessel(target);
		session.save(vesselFeatures);

		// Add or update the vessel into denormalized vessel table
		if (refreshDenormalizedVessel) {
			if (log.isDebugEnabled()) {
				log.debug("Refresh denormalizedVessel for this vessel");
			}

			int rowCount = queryUpdate("deleteDenormalizedVessels",
					"vesselCodes", StringType.INSTANCE, target.getCode(),
					"programCodes", StringType.INSTANCE, ProgramCode.SIH.getValue());
			if (log.isDebugEnabled()) {
				log.debug(String.format(" %s rows deleted", rowCount));
			}

			DenormalizedVessel dv = DenormalizedVessel.Factory.newInstance();
			dv.setVessel(target);
			dv.setProgram(target.getProgram());
			dv.setName(name);
			dv.setInternationalRegistrationCode(internationalRegistrationCode);
			dv.setRegistrationCode(nationalRegistrationCode);
			dv.setRegistrationStartDate(vrpPK.getStartDateTime());
			dv.setRankOrder(vrp.getRankOrder());
			dv.setRegistrationLocation((LocationImpl) load(LocationImpl.class, registrationLocationId));

			Location countryRegistrationLocationDao = locationDao.getParentLocationByLebel(LocationLevelId.PAYS_ISO3.getValue(),
					registrationLocationId);
			dv.setRegistrationCountry(countryRegistrationLocationDao);

			session.save(dv);
			if (log.isDebugEnabled()) {
				log.debug(" 1 rows inserted");
			}
		}
	}

	/**
	 * Find a safe (not used) vessel code (increment if need)
	 * 
	 * @param vesselCode
	 * @return
	 */
	protected String getUnusedTemporaryVesselCode(String vesselCode) {
		long vesselCount = 1;
		int counter = 1;
		String safeVesselCode = TemporaryDataHelper.TEMPORARY_NAME_PREFIX + vesselCode;
		while (vesselCount > 0) {
			if (counter > 1) {
				safeVesselCode = TemporaryDataHelper.TEMPORARY_NAME_PREFIX + vesselCode + "-" + counter;
			}
			vesselCount = queryUniqueTyped("countVesselByCode",
					"vesselCode", StringType.INSTANCE, safeVesselCode);
			counter++;
		}
		return safeVesselCode;
	}

	protected void refreshAllDenormalizedVesselsJdbc(String[] programCodes, Date refDate, String[] vesselCodes) {
		log.debug("Compute all DenormalizedVessels (using JDBC)");

		int jdbcBatchSize = AdagioConfiguration.getInstance().getJdbcBatchSize();
		if (jdbcBatchSize <= 0) {
			jdbcBatchSize = 1;
		}
		Logger hibernateLogger = Logger.getLogger("org.hibernate.SQL");

		// Prepare refDate
		if (refDate == null) {
			refDate = new Date();
		}
		// Prepare refDate
		if (refDate == null) {
			refDate = new Date();
		}

		Connection connection = null;
		StatelessSession session = null;
		try {
			connection = dataSource.getConnection();
			session = getSessionFactory().openStatelessSession(connection);

			// Delete old rows
			Query query = null;
			if (vesselCodes == null || vesselCodes.length == 0) {
				query = session.getNamedQuery("deleteAllDenormalizedVessels");
			} else {
				query = session.getNamedQuery("deleteDenormalizedVessels");
				query.setParameterList("vesselCodes", vesselCodes);
			}
			query.setParameterList("programCodes", programCodes);
			int rowCount = query.executeUpdate();
			if (log.isDebugEnabled()) {
				log.debug(String.format(" %s rows deleted", rowCount));
			}

			// Get insert SQL query
			SQLQuery insertQuery = (SQLQuery) session.getNamedQuery("insertDenormalizedVessel");
			String insertQueryString = insertQuery.getQueryString();
			insertQueryString = insertQueryString.replaceAll(":[a-zA-Z]+", "?").replaceAll("[\\s\n\r]+", " ");
			PreparedStatement ps = connection.prepareStatement(insertQueryString);

			// Get denormalized rows
			query = DaoUtils.withStatus(session.getNamedQuery("denormalizedVessels"))
					.setCacheable(false).setReadOnly(true);
			query.setParameter("refDate", refDate);
			query.setParameter("countryLocationLevelId", LocationLevelId.PAYS_ISO3.getValue());
			query.setParameterList("programCodes", programCodes);
			if (vesselCodes == null || vesselCodes.length == 0) {
				query.setParameter("vesselCodes", null);
			} else {
				query.setParameterList("vesselCodes", vesselCodes);
			}

			long time1 = System.currentTimeMillis();

			ScrollableResults results = query.scroll(ScrollMode.FORWARD_ONLY);
			rowCount = 0;
			TreeSet<String> vesselCodeList = Sets.newTreeSet();
			while (results.next()) {
				Object[] row = results.get();

				String vesselCode = (String) row[0];
				if (vesselCodeList.contains(vesselCode) == false) {
					vesselCodeList.add(vesselCode);

					int index = 0;
					ps.setString(index + 1, (String) row[index++]); // vesselCode
					ps.setString(index + 1, (String) row[index++]); // programCode
					ps.setString(index + 1, (String) row[index++]); // name
					ps.setString(index + 1, (String) row[index++]); // internationalRegistrationCode
					ps.setString(index + 1, (String) row[index++]); // registrationCode
					ps.setTimestamp(index + 1, (Timestamp) row[index++]); // registrationStartDateTime
					ps.setTimestamp(index + 1, (Timestamp) row[index++]); // registrationEndDateTime
					if (row[index] != null) {
						ps.setShort(index + 1, (Short) row[index++]); // rankOrder
					} else {
						// Force to 1
						ps.setShort(index + 1, (short) 1);
						index++;
					}
					ps.setString(index + 1, (String) row[index++]); // exteriorMarking
					if (row[index] != null) { // registrationLocationId
						ps.setInt(index + 1, (Integer) row[index++]);
					} else {
						ps.setNull(index + 1, Types.INTEGER);
						index++;
					}
					if (row[index] != null) { // registrationCountryId
						ps.setInt(index + 1, (Integer) row[index++]);
					} else {
						ps.setNull(index + 1, Types.INTEGER);
						index++;
					}
					if (row[index] != null) { // vesselOwnerId
						ps.setInt(index + 1, (Integer) row[index++]);
					} else {
						ps.setNull(index + 1, Types.INTEGER);
						index++;
					}
					// basePortLocationId
					if (row[index] != null) {
						ps.setInt(index + 1, (Integer) row[index++]);
					} else {
						ps.setNull(index + 1, Types.INTEGER);
						index++;
					}

					// ps.executeUpdate();
					ps.addBatch();

					if (rowCount % jdbcBatchSize == 0) { // same as the JDBC batch size
						// flush a batch of inserts and release memory:
						if (hibernateLogger.isDebugEnabled()) {
							hibernateLogger.debug(insertQueryString);
						}
						ps.executeBatch();
					}
					rowCount++;
				}
			}

			if (rowCount - 1 % jdbcBatchSize != 0) {
				// flush a batch of inserts and release memory:
				if (hibernateLogger.isDebugEnabled()) {
					hibernateLogger.debug(insertQueryString);
				}
				ps.executeBatch();
			}

			if (log.isDebugEnabled()) {
				long time2 = System.currentTimeMillis() - time1;
				log.debug(String.format(" %s rows inserted in %s ms", rowCount, time2));
			}
		} catch (SQLException e) {
			log.warn("Error while trying to insert rows into DENORMALIZED_VESSELS: " + e.getMessage(), e);
		} finally {
			if (session != null) {
				session.close();
			}
			DaoUtils.closeSilently(connection);
		}
	}
}