// Generated by: hibernate/SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.observedLocation;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Collection;

import org.apache.commons.collections.CollectionUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;

import fr.ifremer.adagio.core.dao.data.measure.ObservedLocationMeasurement;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmImpl;

/**
 * @see fr.ifremer.adagio.core.dao.data.survey.observedLocation.ObservedLocationFeatures
 */
@Repository("observedLocationFeaturesDao")
@Lazy
public class ObservedLocationFeaturesDaoImpl
		extends ObservedLocationFeaturesDaoBase
		implements ObservedLocationFeaturesExtendDao {
	/**
	 * Constructor used by Spring
	 */
	@Autowired
	public ObservedLocationFeaturesDaoImpl(SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public ObservedLocationMeasurement getObservedLocationMeasurement(ObservedLocation observedLocation, ObservedLocationFeatures features,
			Integer pmfmId,
			boolean createIfNotExists) {
		ObservedLocationMeasurement observedLocationMeasurement = null;
		if (features.getObservedLocationMeasurements() != null) {
			for (ObservedLocationMeasurement vum : features.getObservedLocationMeasurements()) {
				if (pmfmId.equals(vum.getPmfm().getId())) {
					observedLocationMeasurement = vum;
					break;
				}
			}
		}
		if (observedLocationMeasurement == null) {
			if (!createIfNotExists) {
				return null;
			}
			observedLocationMeasurement = ObservedLocationMeasurement.Factory.newInstance();
			observedLocationMeasurement.setObservedLocationFeatures(features);
			if (features.getObservedLocationMeasurements() == null) {
				features.setObservedLocationMeasurements(Lists.newArrayList(observedLocationMeasurement));
			} else {
				features.getObservedLocationMeasurements().add(observedLocationMeasurement);
			}
			observedLocationMeasurement.setQualityFlag(load(QualityFlagImpl.class, QualityFlagCode.NOTQUALIFIED.getValue()));
			observedLocationMeasurement.setDepartment(observedLocation.getRecorderDepartment());
			Pmfm pmfm = load(PmfmImpl.class, pmfmId);
			observedLocationMeasurement.setPmfm(pmfm);
		}

		return observedLocationMeasurement;
	}

	public void remove(Collection<ObservedLocationFeatures> entities) {
		if (entities == null) {
			throw new IllegalArgumentException(
					"ObservedLocationFeatures.remove - 'entities' can not be null");
		}
		for (ObservedLocationFeatures entity : entities) {
			remove(entity);
		}
	}

	@Override
	public void remove(ObservedLocationFeatures observedLocationFeatures) {
		if (CollectionUtils.isNotEmpty(observedLocationFeatures.getObservedLocationMeasurements())) {
			observedLocationFeatures.getObservedLocationMeasurements().clear();
		}
		super.remove(observedLocationFeatures);
	}
}