// Generated by: hibernate/SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.observedLocation;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Collection;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;

import fr.ifremer.adagio.core.dao.data.history.DeletedItemHistoryExtendDao;
import fr.ifremer.adagio.core.dao.data.survey.activity.DailyActivityCalendarExtendDao;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTripExtendDao;
import fr.ifremer.adagio.core.dao.data.survey.landing.Landing;
import fr.ifremer.adagio.core.dao.data.survey.landing.LandingExtendDao;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;

/**
 * @see fr.ifremer.adagio.core.dao.data.survey.observedLocation.ObservedLocation
 */
@Repository("observedLocationDao")
@Lazy
public class ObservedLocationDaoImpl
		extends ObservedLocationDaoBase
		implements ObservedLocationExtendDao {

	@Resource
	private LandingExtendDao landingDao;

	@Resource
	private FishingTripExtendDao fishingtripDao;

	@Resource
	private ObservedLocationFeaturesExtendDao observedLocationFeaturesDao;

	@Resource
	private DailyActivityCalendarExtendDao dailyActivityCalendarDao;

	@Resource
	private DeletedItemHistoryExtendDao deletedItemHistoryDao;

	/**
	 * Constructor used by Spring
	 */
	@Autowired
	public ObservedLocationDaoImpl(SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	public void remove(ObservedLocation observedLocation) {
		// Cascade to features
		if (CollectionUtils.isNotEmpty(observedLocation.getObservedLocationFeatures())) {
			observedLocationFeaturesDao.remove(observedLocation.getObservedLocationFeatures());
			observedLocation.getObservedLocationFeatures().clear();
		}

		// Cascade to observers
		if (CollectionUtils.isNotEmpty(observedLocation.getObservers())) {
			observedLocation.getObservers().clear();
		}

		// Cascade to fishing trip (should delete attached landings)
		Collection<FishingTrip> fishingTrips = getFishingTrips(observedLocation);
		if (CollectionUtils.isNotEmpty(fishingTrips)) {
			fishingtripDao.remove(fishingTrips);
		}

		// Cascade to daily activity calendar
		if (CollectionUtils.isNotEmpty(observedLocation.getDailyActivityCalendars())) {
			dailyActivityCalendarDao.remove(observedLocation.getDailyActivityCalendars());
		}

		// Flush to make sure fishing trip has deleted attached landings
		// Then reload to make sure landings are reloaded
		getSession().flush();
		getSession().clear();
		observedLocation = get(observedLocation.getId());

		// Cascade to landings (those that are not linked to fishingTrip)
		// This must be done after fishingTrip deletion,
		// because fishingTripDao will delete attached landings
		if (CollectionUtils.isNotEmpty(observedLocation.getLandings())) {
			landingDao.remove(observedLocation.getLandings());
			getSession().flush();
		}

		// delete the entity itself
		super.remove(observedLocation);
	};

	@Override
	public void removeUsingDeletedItemHistory(int observedLocationId, Integer recorderPersonId) {
		// Load entity by id
		ObservedLocation observedLocation = get(observedLocationId);
		boolean hasBeenSynchronized = (observedLocation.getRemoteId() != null);

		// If entity is not in server: do a classic remove
		if (!hasBeenSynchronized) {
			remove(observedLocation);
			return;
		}

		Preconditions.checkNotNull(recorderPersonId, "Argument 'recorderPersonId' must not be null");

		// Cascade to fishing trip
		Collection<FishingTrip> fishingTrips = getFishingTrips(observedLocation);
		if (CollectionUtils.isNotEmpty(fishingTrips)) {
			fishingtripDao.removeUsingDeletedItemHistory(fishingTrips, recorderPersonId);
		}

		// Cascade to landings
		// => not need (Landing is not a root table in the synchro process)

		// Cascade to daily activity calendar
		if (CollectionUtils.isNotEmpty(observedLocation.getDailyActivityCalendars())) {
			dailyActivityCalendarDao.removeUsingDeletedItemHistory(observedLocation.getDailyActivityCalendars(), recorderPersonId);
		}

		// Add a record into DeletedItemHistory
		deletedItemHistoryDao.insertDeletedItem(
				ObservedLocationImpl.class,
				observedLocation,
				recorderPersonId);

		// Change synchronization status to DELETED
		observedLocation.setSynchronizationStatus(SynchronizationStatus.DELETED.getValue());
		getSession().save(observedLocation);
	}

	/* -- Internal methods-- */

	protected Collection<FishingTrip> getFishingTrips(ObservedLocation observedLocation) {
		return getFishingTrips(observedLocation.getLandings());
	}

	protected Collection<FishingTrip> getFishingTrips(Collection<Landing> landings) {
		if (CollectionUtils.isEmpty(landings)) {
			return null;
		}

		List<FishingTrip> result = Lists.newArrayListWithExpectedSize(landings.size());

		for (Landing landing : landings) {
			if (landing.getFishingTrip() != null) {
				result.add(landing.getFishingTrip());
			}
		}

		return result;
	}
}