// Generated by: hibernate/SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.landing;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.apache.commons.collections.CollectionUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import fr.ifremer.adagio.core.dao.data.measure.LandingMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SurveyMeasurement;
import fr.ifremer.adagio.core.dao.data.produce.Produce;
import fr.ifremer.adagio.core.dao.data.produce.ProduceExtendDao;
import fr.ifremer.adagio.core.dao.data.sale.ExpectedSaleDao;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmImpl;

/**
 * @see fr.ifremer.adagio.core.dao.data.survey.landing.ObservedLanding
 */
@Repository("observedLandingDao")
@Lazy
public class ObservedLandingDaoImpl
		extends ObservedLandingDaoBase
		implements ObservedLandingExtendDao {

	@Autowired
	private ProduceExtendDao produceDao;

	@Autowired
	private ExpectedSaleDao expectedSaleDao;

	/**
	 * Constructor used by Spring
	 */
	@Autowired
	public ObservedLandingDaoImpl(SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public LandingMeasurement getLandingMeasurement(Landing landing,
			Integer pmfmId,
			boolean createIfNotExists) {
		LandingMeasurement landingMeasurement = null;
		if (landing.getLandingMeasurements() != null) {
			for (LandingMeasurement lm : landing.getLandingMeasurements()) {
				if (pmfmId.equals(lm.getPmfm().getId())) {
					landingMeasurement = lm;
					break;
				}
			}
		}
		if (landingMeasurement == null) {
			if (!createIfNotExists) {
				return null;
			}
			landingMeasurement = LandingMeasurement.Factory.newInstance();
			landingMeasurement.setLanding(landing);
			if (landing.getLandingMeasurements() == null) {
				landing.setLandingMeasurements(Sets.newHashSet(landingMeasurement));
			} else {
				landing.getLandingMeasurements().add(landingMeasurement);
			}
			landingMeasurement.setQualityFlag(load(QualityFlagImpl.class, QualityFlagCode.NOTQUALIFIED.getValue()));
			landingMeasurement.setDepartment(landing.getRecorderDepartment());
			Pmfm pmfm = load(PmfmImpl.class, pmfmId);
			landingMeasurement.setPmfm(pmfm);
		}

		return landingMeasurement;
	}

	@Override
	public SurveyMeasurement getSurveyMeasurement(Landing landing,
			Integer pmfmId,
			boolean createIfNotExists) {
		SurveyMeasurement surveyMeasurement = null;
		if (landing.getLandingMeasurements() != null) {
			for (SurveyMeasurement lm : landing.getSurveyMeasurements()) {
				if (pmfmId.equals(lm.getPmfm().getId())) {
					surveyMeasurement = lm;
					break;
				}
			}
		}
		if (surveyMeasurement == null) {
			if (!createIfNotExists) {
				return null;
			}
			surveyMeasurement = SurveyMeasurement.Factory.newInstance();
			surveyMeasurement.setLanding(landing);
			if (landing.getSurveyMeasurements() == null) {
				landing.setSurveyMeasurements(Sets.newHashSet(surveyMeasurement));
			} else {
				landing.getSurveyMeasurements().add(surveyMeasurement);
			}
			surveyMeasurement.setQualityFlag(load(QualityFlagImpl.class, QualityFlagCode.NOTQUALIFIED.getValue()));
			surveyMeasurement.setDepartment(landing.getRecorderDepartment());
			Pmfm pmfm = load(PmfmImpl.class, pmfmId);
			surveyMeasurement.setPmfm(pmfm);
		}

		return surveyMeasurement;
	}

	@Override
	public void remove(ObservedLanding observedLanding) {

		if (CollectionUtils.isNotEmpty(observedLanding.getProduces())) {
			for (Produce produce : observedLanding.getProduces()) {
				produce.getProduceQuantificationMeasurements().clear();
				produce.getProduceSortingMeasurements().clear();
				getSession().delete(produce);
			}
			observedLanding.getProduces().clear();
			getSession().flush();
		}

		if (CollectionUtils.isNotEmpty(observedLanding.getExpectedSales())) {
			expectedSaleDao.remove(observedLanding.getExpectedSales());
			observedLanding.getExpectedSales().clear();
			getSession().flush();
		}

		if (CollectionUtils.isNotEmpty(observedLanding.getLandingMeasurements())) {
			observedLanding.getLandingMeasurements().clear();
		}

		if (CollectionUtils.isNotEmpty(observedLanding.getSurveyMeasurements())) {
			observedLanding.getSurveyMeasurements().clear();
		}

		if (CollectionUtils.isNotEmpty(observedLanding.getObserverPersons())) {
			observedLanding.getObserverPersons().clear();
		}

		// Make sure the entity will not be re-saved
		if (observedLanding.getFishingTrip() != null) {
			observedLanding.getFishingTrip().removeLandings(observedLanding);
			observedLanding.setFishingTrip(null);
		}

		super.remove(observedLanding);
	}
}