// Generated by: hibernate/SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.landing;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Collection;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.ImmutableList;

import fr.ifremer.adagio.core.dao.data.history.DeletedItemHistoryExtendDao;
import fr.ifremer.adagio.core.dao.data.produce.Produce;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTripExtendDao;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;

/**
 * @see fr.ifremer.adagio.core.dao.data.survey.landing.Landing
 */
@Repository("landingDao")
@Lazy
public class LandingDaoImpl
		extends LandingDaoBase
		implements LandingExtendDao {

	@Resource
	private ObservedLandingDao observedLandingDao;

	@Resource
	private FishingTripExtendDao fishingTripDao;

	@Resource
	private DeletedItemHistoryExtendDao deletedItemHistoryDao;

	/**
	 * Constructor used by Spring
	 */
	@Autowired
	public LandingDaoImpl(SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public void remove(Collection<Landing> entities) {
		if (entities == null) {
			throw new IllegalArgumentException(
					"LandingDao.remove - 'entities' can not be null");
		}
		// Copy the list, to avoid a concurentException if this list come from 'fishingTrip.getLandings()'
		// because of the call to: landing.getFishingTrip().removeLandings(observedLanding)
		Collection<Landing> entitiesCopy = ImmutableList.copyOf(entities);
		for (Landing landing : entitiesCopy) {
			remove(landing);
		}
	}

	@Override
	public void remove(Landing landing) {
		if (landing instanceof ObservedLanding) {
			observedLandingDao.remove((ObservedLanding) landing);
			return;
		}

		if (CollectionUtils.isNotEmpty(landing.getProduces())) {
			for (Produce produce : landing.getProduces()) {
				produce.getProduceQuantificationMeasurements().clear();
				produce.getProduceSortingMeasurements().clear();
				getSession().delete(produce);
			}
			landing.getProduces().clear();
			getSession().flush();
		}

		if (CollectionUtils.isNotEmpty(landing.getLandingMeasurements())) {
			landing.getLandingMeasurements().clear();
		}

		// Make sure the entity will not be re-saved
		if (landing.getFishingTrip() != null) {
			landing.getFishingTrip().removeLandings(landing);
			landing.setFishingTrip(null);
		}

		super.remove(landing);
	}

	@Override
	public void removeUsingDeletedItemHistory(int landingId, int recorderPersonId) {
		Landing landing = get(landingId);
		removeUsingDeletedItemHistory(landing, recorderPersonId);
	};

	@Override
	public void removeUsingDeletedItemHistory(Collection<Landing> landings, int recorderPersonId) {
		for (Landing landing : landings) {
			removeUsingDeletedItemHistory(landing, recorderPersonId);
		}
	}

	@Override
	public void removeUsingDeletedItemHistory(Landing entity, int recorderPersonId) {
		// Add a record into DeletedItemHistory
		deletedItemHistoryDao.insertDeletedItem(
				LandingImpl.class,
				entity,
				recorderPersonId);

		// Change synchronization status to DELETED
		entity.setSynchronizationStatus(SynchronizationStatus.DELETED.getValue());
		getSession().save(entity);
	}

	/* -- Internal methods -- */
}