// Generated by: hibernate/SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.fishingTrip;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Collection;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.ImmutableList;

import fr.ifremer.adagio.core.dao.data.history.DeletedItemHistoryExtendDao;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperationDao;
import fr.ifremer.adagio.core.dao.data.operation.OperationDao;
import fr.ifremer.adagio.core.dao.data.survey.landing.Landing;
import fr.ifremer.adagio.core.dao.data.survey.landing.LandingDao;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.VesselUseFeatures;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;

/**
 * @see fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTripOrigin
 */
@Repository("fishingTripDao")
@Lazy
public class FishingTripDaoImpl
		extends FishingTripDaoBase
		implements FishingTripExtendDao {

	@Resource
	private OperationDao operationDao;

	@Resource
	private FishingOperationDao fishingOperationDao;

	@Resource
	private ObservedFishingTripDao observedFishingTripDao;

	@Resource
	private LandingDao landingDao;

	@Resource
	private DeletedItemHistoryExtendDao deletedItemHistoryDao;

	/**
	 * Constructor used by Spring
	 */
	@Autowired
	public FishingTripDaoImpl(SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public void remove(Collection<FishingTrip> entities) {
		if (entities == null) {
			throw new IllegalArgumentException(
					"FishingTrip.remove - 'entities' can not be null");
		}
		for (FishingTrip entity : entities) {
			remove(entity);
		}
	}

	@Override
	public void remove(FishingTrip fishingTrip) {

		if (fishingTrip instanceof FishingTripImpl) {
			FishingTripImpl ft = (FishingTripImpl) fishingTrip;

			if (CollectionUtils.isNotEmpty(ft.getFishingOperations())) {
				fishingOperationDao.remove(ft.getFishingOperations());
				ft.getFishingOperations().clear();
				fishingTrip.getOperations().removeAll(ft.getFishingOperations());
			}
		}

		if (CollectionUtils.isNotEmpty(fishingTrip.getOperations())) {
			operationDao.remove(fishingTrip.getOperations());
		}

		if (CollectionUtils.isNotEmpty(fishingTrip.getLandings())) {
			landingDao.remove(ImmutableList.copyOf(fishingTrip.getLandings()));
			fishingTrip.getLandings().clear();
		}

		// Survey measurement
		if (CollectionUtils.isNotEmpty(fishingTrip.getSurveyMeasurements())) {
			fishingTrip.getSurveyMeasurements().clear();
		}

		// Delete vessel use features
		if (CollectionUtils.isNotEmpty(fishingTrip.getVesselUseFeatures())) {
			for (VesselUseFeatures vesselUseFeatures : fishingTrip.getVesselUseFeatures()) {

				vesselUseFeatures.setOperation(null);
				vesselUseFeatures.getVesselUseMeasurements().clear();
			}
			// must remove all features content before removing them (data integrity will then failed otherwise)
			getSession().flush();
			fishingTrip.getVesselUseFeatures().clear();
		}

		// Delete gear physical features
		if (CollectionUtils.isNotEmpty(fishingTrip.getGearPhysicalFeatures())) {
			for (GearPhysicalFeatures gearPhysicalFeatures : fishingTrip.getGearPhysicalFeatures()) {

				gearPhysicalFeatures.setOperations(null);
				gearPhysicalFeatures.getGearPhysicalMeasurements().clear();
			}
			// must remove all features content before removing them (data integrity will then failed otherwise)
			getSession().flush();
			fishingTrip.getGearPhysicalFeatures().clear();
		}

		super.remove(fishingTrip);
	}

	@Override
	public void removeUsingDeletedItemHistory(int fishingTripId, int recorderPersonId) {
		FishingTrip fishingTrip = get(fishingTripId);
		removeUsingDeletedItemHistory(fishingTrip, recorderPersonId);
	};

	@Override
	public void removeUsingDeletedItemHistory(Collection<FishingTrip> fishingTrips, int recorderPersonId) {
		for (FishingTrip fishingTrip : fishingTrips) {
			removeUsingDeletedItemHistory(fishingTrip, recorderPersonId);
		}
	}

	@Override
	public void removeUsingDeletedItemHistory(FishingTrip entity, int recorderPersonId) {
		// TODO : cascade to children: OPERATION -> BATCH

		// Add a record into DeletedItemHistory
		deletedItemHistoryDao.insertDeletedItem(
				FishingTripImpl.class,
				entity,
				recorderPersonId);

		// Change synchronization status to DELETED
		entity.setSynchronizationStatus(SynchronizationStatus.DELETED.getValue());
		getSession().save(entity);
	}

	/* -- Internal methods -- */

}