// Generated by: hibernate/SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.activity;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Collection;
import java.util.Set;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Sets;

import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea2RegulationLocationDao;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingAreaDao;
import fr.ifremer.adagio.core.dao.data.history.DeletedItemHistoryExtendDao;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.GearUseFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.VesselUseFeatures;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;

/**
 * @see fr.ifremer.adagio.core.dao.data.survey.activity.DailyActivityCalendar
 */
@Repository("dailyActivityCalendarDao")
@Lazy
public class DailyActivityCalendarDaoImpl
		extends DailyActivityCalendarDaoBase
		implements DailyActivityCalendarExtendDao {

	@Resource
	protected FishingArea2RegulationLocationDao fishingArea2RegulationLocationDao;

	@Resource
	protected FishingAreaDao fishingAreaDao;

	@Resource
	private DeletedItemHistoryExtendDao deletedItemHistoryDao;

	/**
	 * Constructor used by Spring
	 */
	@Autowired
	public DailyActivityCalendarDaoImpl(SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public void remove(Collection<DailyActivityCalendar> entities) {
		if (entities == null) {
			throw new IllegalArgumentException(
					"DailyActivityCalendar.remove - 'entities' can not be null");
		}
		for (DailyActivityCalendar entity : entities) {
			remove(entity);
		}
	}

	@Override
	public void remove(DailyActivityCalendar dailyActivityCalendar) {

		Set<FishingArea> fishingAreas = Sets.newHashSet();

		// Remove gear use features
		if (CollectionUtils.isNotEmpty(dailyActivityCalendar.getGearUseFeatures())) {
			for (GearUseFeatures gearUseFeatures : dailyActivityCalendar.getGearUseFeatures()) {

				gearUseFeatures.setDailyActivityCalendar(null);
				gearUseFeatures.getGearUseMeasurements().clear();

				if (CollectionUtils.isNotEmpty(gearUseFeatures.getFishingAreas())) {
					for (FishingArea fishingArea : gearUseFeatures.getFishingAreas()) {
						fishingArea.setGearUseFeatures(null);
					}
					fishingAreas.addAll(gearUseFeatures.getFishingAreas());
				}
			}
			// must remove all features content before removing them (data integrity will then failed otherwise)
			getSession().flush();
			dailyActivityCalendar.getGearUseFeatures().clear();
		}

		// Remove vessel use features
		if (CollectionUtils.isNotEmpty(dailyActivityCalendar.getVesselUseFeatures())) {
			for (VesselUseFeatures vesselUseFeatures : dailyActivityCalendar.getVesselUseFeatures()) {

				vesselUseFeatures.setDailyActivityCalendar(null);
				vesselUseFeatures.getVesselUseMeasurements().clear();

				if (CollectionUtils.isNotEmpty(vesselUseFeatures.getFishingAreas())) {
					for (FishingArea fishingArea : vesselUseFeatures.getFishingAreas()) {
						fishingArea.setVesselUseFeatures(null);
					}
					fishingAreas.addAll(vesselUseFeatures.getFishingAreas());
				}
			}

			// must remove all features content before removing them (data integrity will then failed otherwise)
			getSession().flush();
			dailyActivityCalendar.getVesselUseFeatures().clear();
		}

		// Remove collected fishing areas
		if (CollectionUtils.isNotEmpty(fishingAreas)) {
			for (FishingArea fishingArea : fishingAreas) {
				fishingArea.setProduce(null);
				fishingArea.setGearUseFeatures(null);
				fishingArea2RegulationLocationDao.remove(fishingArea.getRegulationLocations());
				fishingArea.getRegulationLocations().clear();
			}
			getSession().flush();
			fishingAreaDao.remove(fishingAreas);
		}

		getSession().flush();

		super.remove(dailyActivityCalendar);
	}

	@Override
	public void removeUsingDeletedItemHistory(int entityId, int recorderPersonId) {
		DailyActivityCalendar entity = get(entityId);
		removeUsingDeletedItemHistory(entity, recorderPersonId);
	};

	@Override
	public void removeUsingDeletedItemHistory(Collection<DailyActivityCalendar> entities, int recorderPersonId) {
		for (DailyActivityCalendar entity : entities) {
			removeUsingDeletedItemHistory(entity, recorderPersonId);
		}
	}

	@Override
	public void removeUsingDeletedItemHistory(DailyActivityCalendar entity, int recorderPersonId) {

		// Add a record into DeletedItemHistory
		deletedItemHistoryDao.insertDeletedItem(
				DailyActivityCalendarImpl.class,
				entity,
				recorderPersonId);

		// Change synchronization status to DELETED
		entity.setSynchronizationStatus(SynchronizationStatus.DELETED.getValue());
		getSession().save(entity);
	}

}