// Generated by: hibernate/SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.sale;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Collection;

import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentImpl;
import fr.ifremer.adagio.core.dao.data.measure.SaleMeasurement;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueImpl;

/**
 * @see fr.ifremer.adagio.core.dao.data.sale.ExpectedSale
 */
@Repository("expectedSaleDao")
@Lazy
public class ExpectedSaleDaoImpl
		extends ExpectedSaleDaoBase
		implements ExpectedSaleExtendDao {
	/**
	 * Constructor used by Spring
	 */
	@Autowired
	public ExpectedSaleDaoImpl(SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public SaleMeasurement setSaleMeasurement(ExpectedSale expectedSale,
			Integer pmfmId,
			Float numericalValue,
			String alphanumericalValue,
			Integer qualitativevalueId,
			Integer recorderDepartmentId) {
		SaleMeasurement saleMeasurement = getSaleMeasurement(expectedSale, pmfmId, true);

		if (alphanumericalValue != null) {
			saleMeasurement.setAlphanumericalValue(alphanumericalValue);
		} else if (numericalValue != null) {
			saleMeasurement.setNumericalValue(numericalValue);
		} else if (qualitativevalueId != null) {
			QualitativeValue qv = load(QualitativeValueImpl.class, qualitativevalueId);
			saleMeasurement.setQualitativeValue(qv);
		}

		if (recorderDepartmentId != null) {
			saleMeasurement.setDepartment(load(DepartmentImpl.class, recorderDepartmentId));
		}

		return saleMeasurement;
	}

	@Override
	public SaleMeasurement getSaleMeasurement(ExpectedSale expectedSale, Integer pmfmId) {
		return getSaleMeasurement(expectedSale, pmfmId, false);
	}

	@Override
	public void remove(Collection<ExpectedSale> entities) {
		if (entities == null) {
			throw new IllegalArgumentException(
					"ExpectedSale.remove - 'entities' can not be null");
		}
		for (ExpectedSale entity : entities) {
			remove(entity);
		}
	}

	@Override
	public void remove(ExpectedSale expectedSale) {
		if (CollectionUtils.isNotEmpty(expectedSale.getSaleMeasurements())) {
			expectedSale.getSaleMeasurements().clear();
		}

		super.remove(expectedSale);
	}

	/* -- Internal methods -- */

	private SaleMeasurement getSaleMeasurement(ExpectedSale expectedSale, Integer pmfmId, boolean createIfNotExists) {
		SaleMeasurement saleMeasurement = null;
		if (expectedSale.getSaleMeasurements() != null) {
			for (SaleMeasurement vum : expectedSale.getSaleMeasurements()) {
				if (pmfmId.equals(vum.getPmfm().getId())) {
					saleMeasurement = vum;
					break;
				}
			}
		}
		if (saleMeasurement == null) {
			if (!createIfNotExists) {
				return null;
			}
			saleMeasurement = SaleMeasurement.Factory.newInstance();
			saleMeasurement.setExpectedSale(expectedSale);
			if (expectedSale.getSaleMeasurements() == null) {
				expectedSale.setSaleMeasurements(Sets.newHashSet(saleMeasurement));
			} else {
				expectedSale.getSaleMeasurements().add(saleMeasurement);
			}
			saleMeasurement.setQualityFlag(load(QualityFlagImpl.class, QualityFlagCode.NOTQUALIFIED.getValue()));
			Pmfm pmfm = load(PmfmImpl.class, pmfmId);
			saleMeasurement.setPmfm(pmfm);
		}

		return saleMeasurement;
	}

}