// Generated by: hibernate/SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.produce;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Collection;

import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;

import fr.ifremer.adagio.core.dao.administration.user.DepartmentImpl;
import fr.ifremer.adagio.core.dao.data.measure.ProduceQuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.ProduceSortingMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperation;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmImpl;

/**
 * @see fr.ifremer.adagio.core.dao.data.produce.Produce
 */
@Repository("produceDao")
@Lazy
public class ProduceDaoImpl extends ProduceDaoBase implements ProduceExtendDao {
	/**
	 * Constructor used by Spring
	 */
	@Autowired
	public ProduceDaoImpl(SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public ProduceQuantificationMeasurement getQuantificationMeasurement(Produce produce,
			Integer pmfmId,
			boolean createIfNotExists,
			Integer recorderDepartmentId) {
		ProduceQuantificationMeasurement produceQuantificationMeasurement = null;
		if (produce.getProduceQuantificationMeasurements() != null) {
			for (ProduceQuantificationMeasurement vum : produce.getProduceQuantificationMeasurements()) {
				if (pmfmId.equals(vum.getPmfm().getId())) {
					produceQuantificationMeasurement = vum;
					break;
				}
			}
		}
		if (produceQuantificationMeasurement == null) {
			if (!createIfNotExists) {
				return null;
			}
			produceQuantificationMeasurement = ProduceQuantificationMeasurement.Factory.newInstance();
			produceQuantificationMeasurement.setProduce(produce);
			if (produce.getProduceQuantificationMeasurements() == null) {
				produce.setProduceQuantificationMeasurements(Lists.newArrayList(produceQuantificationMeasurement));
			} else {
				produce.getProduceQuantificationMeasurements().add(produceQuantificationMeasurement);
			}
			produceQuantificationMeasurement.setQualityFlag(load(QualityFlagImpl.class, QualityFlagCode.NOTQUALIFIED.getValue()));
			produceQuantificationMeasurement.setDepartment(load(DepartmentImpl.class, recorderDepartmentId));
			produceQuantificationMeasurement.setPmfm(load(PmfmImpl.class, pmfmId));
		}

		return produceQuantificationMeasurement;
	}

	@Override
	public ProduceSortingMeasurement getSortingMeasurement(Produce produce,
			Integer pmfmId,
			boolean createIfNotExists,
			Integer recorderDepartmentId) {
		ProduceSortingMeasurement produceSortingMeasurement = null;
		if (produce.getProduceSortingMeasurements() != null) {
			for (ProduceSortingMeasurement vum : produce.getProduceSortingMeasurements()) {
				if (pmfmId.equals(vum.getPmfm().getId())) {
					produceSortingMeasurement = vum;
					break;
				}
			}
		}
		if (produceSortingMeasurement == null) {
			if (!createIfNotExists) {
				return null;
			}
			produceSortingMeasurement = ProduceSortingMeasurement.Factory.newInstance();
			produceSortingMeasurement.setProduce(produce);
			if (produce.getProduceSortingMeasurements() == null) {
				produce.setProduceSortingMeasurements(Lists.newArrayList(produceSortingMeasurement));
			} else {
				produce.getProduceSortingMeasurements().add(produceSortingMeasurement);
			}
			produceSortingMeasurement.setQualityFlag(load(QualityFlagImpl.class, QualityFlagCode.NOTQUALIFIED.getValue()));
			produceSortingMeasurement.setDepartment(load(DepartmentImpl.class, recorderDepartmentId));
			produceSortingMeasurement.setPmfm(load(PmfmImpl.class, pmfmId));
		}

		return produceSortingMeasurement;
	}

	@Override
	public void remove(Integer id) {
		Produce target = get(ProduceImpl.class, id);
		remove(target);
	};

	@Override
	public void remove(Collection<Produce> entities) {
		if (entities == null) {
			throw new IllegalArgumentException(
					"ProducenDao.remove - 'entities' can not be null");
		}
		for (Produce produce : entities) {
			remove(produce);
		}
	}

	@Override
	public void remove(Produce produce) {

		// remove quantification measurements
		if (CollectionUtils.isNotEmpty(produce.getProduceQuantificationMeasurements())) {
			deleteAll(produce.getProduceQuantificationMeasurements());
			produce.getProduceQuantificationMeasurements().clear();
		}

		// remove sorting measurements
		if (CollectionUtils.isNotEmpty(produce.getProduceSortingMeasurements())) {
			deleteAll(produce.getProduceSortingMeasurements());
			produce.getProduceSortingMeasurements().clear();
		}

		// Add remove on parent entities (if present in session),
		// to avoid an error : "deleted object would be re-saved by cascade (remove deleted object from associations)"
		// (see mantis 23050)
		if (produce.getFishingOperation() != null) {
			produce.getFishingOperation().removeProduces(produce);
		}
		if (produce.getLanding() != null) {
			produce.getLanding().removeProduces(produce);
		}
		if (produce.getExpectedSale() != null) {
			produce.getExpectedSale().removeProduces(produce);
		}
		getSession().delete(produce);
	}
}