package fr.ifremer.adagio.core.dao.data.measure.file;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.File;
import java.util.List;

public interface MeasurementFileExtendDao extends MeasurementFileDao {

	/**
	 * Get all attachments for the given object {@code objectId}.
	 * 
	 * @param objectType
	 *            type of object.
	 * @param objectId
	 *            id of the object
	 * @return list of all attachments for the given {@code objectId}.
	 *         (see {@link ObjectTypeCode})
	 */
	List<Attachment> getAllAttachments(String objectTypeCode,
			Integer objectId);

	/**
	 * Get the file of the given {@code attachmentId}.
	 * 
	 * @param attachmentId
	 *            id of the attachment
	 * @return the file for the given attachment
	 */
	File getAttachmentFile(Integer attachmentId);

	/**
	 * Creates the given attachment.
	 * 
	 * @param attachment
	 *            attachment to create
	 * @param file
	 *            file to store in this attachment
	 * @return the attachment with his id.
	 */
	Attachment createAttachment(Attachment attachment, File file);

	/**
	 * Saves the given attachment.
	 * 
	 * @param attachment
	 *            attachment to create
	 * @return the attachment with his id.
	 */
	Attachment saveAttachment(Attachment attachment);

	/**
	 * Deletes the given attachment given his id.
	 * 
	 * @param attachmentId
	 *            id of the attachment to delete
	 */
	void deleteAttachment(Integer attachmentId);

	/**
	 * Deletes all attachments of the given object ids.
	 * 
	 * @param objectType
	 *            type of attachment
	 * @param objectIds
	 *            ids of object
	 */
	void deleteAllAttachment(String objectTypeCode,
			Integer... objectIds);
}
