// license-header java merge-point
/**
 * This is only generated once! It will never be overwritten.
 * You can (and have to!) safely modify it by hand.
 */
package fr.ifremer.adagio.core.dao.data.history;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Set;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.hibernate.SessionFactory;
import org.hibernate.cache.ehcache.management.impl.BeanUtils;
import org.hibernate.dialect.Dialect;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.nuiton.i18n.I18n;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Repository;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;

import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.administration.user.PersonImpl;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.ObjectType;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeImpl;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import fr.ifremer.adagio.core.service.data.synchro.intercept.ObjectTypeHelper;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: DeletedItemHistoryDaoImpl.java 12554 2015-01-12 13:16:58Z tc1fbb1 $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.8.2/core-allegro/src/main/java/fr/ifremer/adagio/core/dao/data/history/DeletedItemHistoryDaoImpl.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

/**
 * @see fr.ifremer.adagio.core.dao.data.history.DeletedItemHistory
 */
@Repository("deletedItemHistoryDao")
@Lazy
public class DeletedItemHistoryDaoImpl
		extends fr.ifremer.adagio.core.dao.data.history.DeletedItemHistoryDaoBase
		implements DeletedItemHistoryExtendDao {

	private DataSource dataSource;

	private static String UPDATE_DATE_PROPERTY = "updateDate";
	private static String REMOTE_ID_PROPERTY = "remoteId";

	@Resource(name = "hibernateProperties")
	private Properties hibernateProperties;

	@Autowired
	public DeletedItemHistoryDaoImpl(DataSource dataSource, SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
		this.dataSource = dataSource;
	}

	/**
	 * @see fr.ifremer.adagio.core.dao.data.history.DeletedItemHistoryDao#getSysdate()
	 */
	protected java.sql.Timestamp handleGetSysdate() {
		Connection connection = DataSourceUtils.getConnection(dataSource);
		Dialect dialect = Dialect.getDialect(hibernateProperties);

		try {
			Timestamp result = DaoUtils.getCurrentTimestamp(connection, dialect);
			return result;
		} finally {
			DataSourceUtils.releaseConnection(connection, dataSource);
		}
	}

	@Override
	public DeletedItemHistory insertDeletedItem(Class<?> entityClass, Object entity, int recorderPersonId) {

		DeletedItemHistory target = DeletedItemHistory.Factory.newInstance();

		// Object type
		ObjectType objectType = getObjectTypeAndCheckNotNull(entityClass);
		target.setObjectType(objectType);

		// Update date
		Object updateDate = BeanUtils.getBeanProperty(entity, UPDATE_DATE_PROPERTY);
		if (updateDate != null && updateDate instanceof Timestamp) {
			target.setUpdateDate((Timestamp) updateDate);
		}

		// Object id
		{
			// Found the first not null property
			Object remoteId = BeanUtils.getBeanProperty(entity, REMOTE_ID_PROPERTY);
			if (remoteId != null
					&& (remoteId instanceof Long
					|| remoteId instanceof Integer)) {
				Long objectId = Long.parseLong(remoteId.toString());
				target.setObjectId(objectId);
			}

			// Error if no remoteId found (should never happen)
			else {
				throw new AdagioTechnicalException(
						String.format("Could not retrieve a not null %s for an entity %s",
								ArrayUtils.toString(REMOTE_ID_PROPERTY),
								entityClass.getName()));
			}

		}

		// Vessel
		Vessel vessel = (Vessel) BeanUtils.getBeanProperty(entity, "vessel");
		if (vessel != null) {
			String vesselCode = vessel.getCode();
			target.setVesselCode(vesselCode);
		}

		// Recorder person
		Person recorderPerson = getRecorderPersonAndCheck(recorderPersonId);
		target.setRecorderPerson(recorderPerson);

		// Recorder department
		target.setRecorderDepartment(recorderPerson.getDepartment());

		// Comments
		target.setComments(I18n.t("adagio.persistence.deletedItemHistory.new.comments", recorderPersonId));

		// Save
		getSession().save(target);

		return target;
	}

	/* -- protected methods -- */

	protected ObjectType getObjectTypeAndCheckNotNull(Class<?> entityClass) {
		Set<String> allObjectTypesCodes = Sets.newLinkedHashSet();

		// Add a table name to the list of object type to check
		String tableName = getTableNameFromEntity(getSessionFactory(), entityClass);
		Preconditions.checkNotNull(tableName, String.format("Could not found table name from entity class %s", entityClass.getName()));
		allObjectTypesCodes.add(tableName);

		// Add object types from helper
		Set<String> defaultObjecjTypeCodes = ObjectTypeHelper.getObjectTypeFromTableName(tableName);
		if (CollectionUtils.isNotEmpty(defaultObjecjTypeCodes)) {
			allObjectTypesCodes.addAll(defaultObjecjTypeCodes);
		}

		// Retrieve the first not null entity, from the code list
		ObjectType objectType = null;
		for (String objectTypeCode : allObjectTypesCodes) {
			objectType = get(ObjectTypeImpl.class, objectTypeCode);
			if (objectType != null) {
				break;
			}
		}

		if (objectType == null) {
			throw new AdagioTechnicalException(
					String.format("Could not retrieve a object type for entity class %s",
							entityClass.getName()));
		}

		return objectType;
	}

	protected String getTableNameFromEntity(SessionFactory sessionFactory, Class clazz) {
		ClassMetadata hibernateMetadata = sessionFactory.getClassMetadata(clazz.getName());
		if (hibernateMetadata != null) {
			if (hibernateMetadata instanceof AbstractEntityPersister) {
				AbstractEntityPersister persister = (AbstractEntityPersister) hibernateMetadata;
				String tableName = persister.getTableName();
				return tableName;
			}
		}
		return null;
	}

	protected Person getRecorderPersonAndCheck(int recorderPersonId) {
		if (recorderPersonId < 0) {
			throw new DataRetrievalFailureException(
					String.format("Could not set a temporary person (id=%s) as recorder person in DeletedItemHistory",
							recorderPersonId));
		}

		Person recorderPerson = get(PersonImpl.class, recorderPersonId);

		if (recorderPerson == null) {
			throw new DataRetrievalFailureException(
					String.format("Could not load Person with id=%s",
							recorderPersonId));
		}

		return recorderPerson;
	}
}