// Generated by: hibernate/SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.fishingArea;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.Objects;

import org.apache.commons.collections.CollectionUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;

import fr.ifremer.adagio.core.dao.referential.location.LocationImpl;

/**
 * @see fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea
 */
@Repository("fishingAreaDao")
@Lazy
public class FishingAreaDaoImpl
		extends FishingAreaDaoBase implements FishingAreaExtendDao
{
	/**
	 * Constructor used by Spring
	 */
	@Autowired
	public FishingAreaDaoImpl(SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public FishingArea2RegulationLocation getFishingArea2RegulationLocation(FishingArea fishingArea, int regulationLocationId,
			boolean createIfNotExists) {
		Preconditions.checkNotNull(fishingArea);

		// Create the PK
		FishingArea2RegulationLocationPK pk = new FishingArea2RegulationLocationPK();
		pk.setFishingArea((FishingAreaImpl) fishingArea);
		pk.setLocation(load(LocationImpl.class, regulationLocationId));

		// Retrieve exiting regulation location
		FishingArea2RegulationLocation fa2rl = null;
		if (CollectionUtils.isNotEmpty(fishingArea.getRegulationLocations())) {
			for (FishingArea2RegulationLocation existingFa2rl : fishingArea.getRegulationLocations()) {
				FishingArea2RegulationLocationPK existingPk = existingFa2rl.getFishingArea2RegulationLocationPk();
				if (Objects.equals(existingPk, pk)) {
					return fa2rl;
				}
			}
		}

		// If not exists, create if need
		if (fa2rl != null || !createIfNotExists) {
			return fa2rl;
		}

		fa2rl = FishingArea2RegulationLocation.Factory.newInstance();
		fa2rl.setFishingArea2RegulationLocationPk(pk);

		if (fishingArea.getRegulationLocations() == null) {
			fishingArea.setRegulationLocations(Sets.newHashSet(fa2rl));
		} else {
			fishingArea.getRegulationLocations().add(fa2rl);
		}

		return fa2rl;
	}
}