package fr.ifremer.adagio.core.dao.data.batch.validator;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: CatchBatchValidator.java 12089 2014-05-20 19:37:05Z bl05b3e $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.8.2/core-allegro/src/main/java/fr/ifremer/adagio/core/dao/data/batch/validator/CatchBatchValidator.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.List;

import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;

/**
 * Validator of a batch tree.
 * Depending of the use, this could validate a batch tree, and return some errors.
 * 
 * @author blavenie
 * 
 */
public interface CatchBatchValidator {

	/**
	 * Should this validator be used for the tree ?
	 * 
	 * @param catchBatch
	 * @return
	 */
	boolean isEnable(CatchBatch catchBatch);

	/**
	 * @param catchBatch
	 * @return
	 */
	List<CatchBatchValidationError> validate(CatchBatch catchBatch);

}
