// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.batch;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: CatchBatchDaoImpl.java 12556 2015-01-13 11:56:19Z tc1fbb1 $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.8.2/core-allegro/src/main/java/fr/ifremer/adagio/core/dao/data/batch/CatchBatchDaoImpl.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentImpl;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchQuickFix;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationError;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationException;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidator;
import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.type.IntegerType;
import org.springframework.dao.DataRetrievalFailureException;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/**
 * @see CatchBatch
 */
@org.springframework.stereotype.Repository("catchBatchDao")
@org.springframework.context.annotation.Lazy
public class CatchBatchDaoImpl
		extends fr.ifremer.adagio.core.dao.data.batch.CatchBatchDaoBase
		implements CatchBatchExtendDao {

	/** Logger. */
	private static final Log log = LogFactory.getLog(CatchBatchDaoImpl.class);

	protected List<CatchBatchValidator> validators = Lists.newArrayList();

	@Resource(name = "sortingBatchDao")
	protected SortingBatchDao sortingBatchDao;

	@Resource(name = "catchBatchDao")
	protected CatchBatchExtendDao catchBatchDao;

	/**
	 * Constructor used by Spring
	 */
	@org.springframework.beans.factory.annotation.Autowired
	public CatchBatchDaoImpl(org.hibernate.SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	@Override
	public CatchBatch loadFullTree(Integer catchBatchId, Integer pmfmId) {
		// Call method throw the interface, to enable cache use
		return catchBatchDao.loadFullTreeWithCache(catchBatchId, pmfmId, AdagioConfiguration.getInstance().useBacthTreeCache(), false);
	}

	@Override
	public CatchBatch loadFullTree(Integer catchBatchId, Integer pmfmId, boolean validate, boolean quickFix) throws CatchBatchValidationException {
		// Call method throw the interface, to enable cache use
		CatchBatch catchBatch = catchBatchDao.loadFullTreeWithCache(catchBatchId, pmfmId, AdagioConfiguration.getInstance().useBacthTreeCache(),
				false);

		// Catch batch validation
		if (validate) {
			boolean retryValidation = true;
			int quickFixCounter = 0;
			while (retryValidation) {
				// Applied validation
				List<CatchBatchValidationError> errors = validate(catchBatch);
				retryValidation = false;

				// Check if validation results has error with gravity ERROR
				if (errors != null && errors.size() > 0) {
					List<CatchBatchQuickFix> quickFixes = Lists.newArrayList();
					boolean hasGravityError = false;

					for (CatchBatchValidationError error : errors) {
						if (error.getGravity() == CatchBatchValidationError.GRAVITY_ERROR) {
							hasGravityError = true;
							// Store quick fixes if any
							if (quickFix && error.getQuickFixes() != null) {
								quickFixes.addAll(error.getQuickFixes());
							}
						}
					}

					// If errors found but one quick fix could be apply
					if (hasGravityError && quickFix && quickFixes.size() == 1 && quickFixCounter < 2) {
						// applied the quick fix :
						catchBatch = quickFixes.get(0).repair(catchBatch);
						retryValidation = true;
						quickFixCounter++;
					}
					// Error found, and could not be repaired
					else if (hasGravityError) {
						throw new CatchBatchValidationException(errors);
					}
				}

			}
		}
		return catchBatch;
	}

	@Override
	public List<CatchBatchValidationError> validate(CatchBatch catchBatch) {
		List<CatchBatchValidationError> errors = Lists.newArrayList();
		for (CatchBatchValidator validator : validators) {
			if (validator.isEnable(catchBatch)) {
				List<CatchBatchValidationError> result = validator.validate(catchBatch);
				if (result != null && result.size() > 0) {
					errors.addAll(result);
				}
			}
		}
		if (errors.size() == 0) {
			return null;
		}
		return errors;
	}

	@Override
	public SortingBatch getSortingBatch(Collection<Batch> batchs,
			Object... params) {

		if (batchs == null || batchs.size() == 0
				|| params == null || params.length == 0) {
			return null;
		}

		String propertyName = (String) params[0];
		Integer expectedPmfmId = null;
		Integer qualitativeValueId = null;
		Integer referenceTaxonId = null;
		Object[] newParams = null;
		if (PMFM_ID.equals(propertyName)) {
			Preconditions.checkArgument(
					params.length >= 3,
					"Params must be tuple (propertyName, [pmfmId,] value)");
			expectedPmfmId = (Integer) params[1];
			qualitativeValueId = (Integer) params[2];
			newParams = Arrays.copyOfRange(params, 3, params.length);
		} else if (REFERENCE_TAXON_ID.equals(propertyName)) {
			Preconditions.checkArgument(
					params.length >= 2,
					"Params must be tuple (propertyName, [referenceTaxonId,] value)");
			referenceTaxonId = (Integer) params[1];
			newParams = Arrays.copyOfRange(params, 2, params.length);
		} else {
			Preconditions.checkArgument(
					false,
					"Params must be tuple (propertyName, [id,] value), and propertyName must be 'pmfmId' or 'referenceTaxonId'.");
		}

		for (Batch batch : batchs) {
			SortingBatch sortingBatch = (SortingBatch) batch;
			boolean found = false;

			if (expectedPmfmId != null) {
				for (SortingMeasurement sm : sortingBatch.getSortingMeasurements()) {
					Integer pmfmId = sm.getPmfm().getId();
					if (expectedPmfmId.equals(pmfmId)
							&& sm.getQualitativeValue() != null
							&& qualitativeValueId.equals(sm.getQualitativeValue().getId())) {
						found = true;
						break;
					}
				}
			} else if (referenceTaxonId != null
					&& sortingBatch.getReferenceTaxon() != null
					&& referenceTaxonId.equals(sortingBatch.getReferenceTaxon().getId())) {
				found = true;
			}

			if (found) {
				if (newParams != null && newParams.length > 0) {
					return getSortingBatch(sortingBatch.getChildBatchs(), newParams);
				}
				return sortingBatch;
			}
		}
		return null;
	}

	@Override
	public void registerCatchBatchValidator(CatchBatchValidator validator) {
		if (!validators.contains(validator)) {
			validators.add(validator);
		}
	}

	@Override
	public void unregisterCatchBatchValidator(CatchBatchValidator validator) {
		validators.remove(validator);
	}

	@Override
	public void update(CatchBatch catchBatch) {
		super.update(catchBatch);
	}

	@Override
	public void removeWithChildren(Integer batchId) {
		removeWithChildren(batchId, null);
	}

	@Override
	public List<Integer> getAllChildrenIds(Integer batchId) {
		List<Integer> result = Lists.newArrayList();
		getAllChildrenIds(batchId, result);
		// don't keep the top node id
		result.remove(batchId);
		return result;
	}

	@Override
	public void remove(Integer id) {

		Preconditions.checkNotNull(id);

		List<Integer> childrenIds = getAllChildrenIds(id);

		for (Integer childrenId : childrenIds) {
			SortingBatch sortingBatch = load(SortingBatchImpl.class, childrenId);
			sortingBatch.getSortingMeasurements().clear();
			sortingBatch.getQuantificationMeasurements().clear();
			getSession().delete(sortingBatch);
		}
		CatchBatch catchBatch = load(CatchBatchImpl.class, id);
		catchBatch.getQuantificationMeasurements().clear();
		catchBatch.getFishingOperation().setCatchBatch(null);
		super.remove(catchBatch);
	}

	@Override
	public void removeWithChildren(Integer batchId, CatchBatch parentCatchBatch) {
		Iterator<Object[]> childRows = queryIteratorTyped("childBatchIds",
				"parentBatchId", IntegerType.INSTANCE, batchId);

		boolean isCatchBatch = false;

		// First remove all children
		while (childRows.hasNext()) {
			Object[] childRow = childRows.next();
			Integer childBatchId = (Integer) childRow[0];
			Integer rootBatchId = (Integer) childRow[1];
			if (batchId.equals(rootBatchId)) {
				isCatchBatch = true;
			}

			// Recursive call
			removeWithChildren(childBatchId, parentCatchBatch);
		}

		// Then remove the current batch
		if (isCatchBatch) {
			CatchBatch catchBatch = load(CatchBatchImpl.class, batchId);

			catchBatch.getQuantificationMeasurements().clear();
			getSession().delete(catchBatch);
		} else {
			SortingBatch sortingBatch = load(SortingBatchImpl.class, batchId);
			sortingBatch.getSortingMeasurements().clear();
			sortingBatch.getQuantificationMeasurements().clear();
			getSession().delete(sortingBatch);

			// If possible, update the batch tree :
			if (parentCatchBatch != null) {
				SortingBatch existingSortingBatch = parentCatchBatch.getSortingBatchById().get(batchId);
				if (existingSortingBatch != null) {
					Batch parentBatch = existingSortingBatch.getParentBatch();
					parentCatchBatch.getSortingBatchById().remove(batchId);
					if (parentBatch != null) {
						parentBatch.getChildBatchs().remove(existingSortingBatch);
					}
				}
			}
		}
	}

	@Override
	public CatchBatch loadFullTreeWithCache(Integer catchBatchId, Integer pmfmId, boolean useCache, boolean forceReload) {
		long time1 = 0;
		if (logger.isDebugEnabled()) {
			logger.debug("call loadFullTreeWithCache()");
			time1 = System.currentTimeMillis();
		}
		Session session = getSession();

		CatchBatch catchBatch = queryUniqueTyped("catchBatchOnly",
				"catchBatchId", IntegerType.INSTANCE, catchBatchId);

		if (catchBatch == null) {
			return null;
		}

		Map<Integer, SortingBatch> sortingBatchById = catchBatch.getSortingBatchById();

		session.evict(catchBatch);
		catchBatch.setChildBatchs(new HashSet<Batch>());
		// error de all-delete-orphan ?? catchBatch.getChildBatchs().clear();
		computeTechnicalWeights(catchBatch, pmfmId);

		Map<Integer, Integer> parentBatchMapById = new HashMap<Integer, Integer>();

		List<SortingBatch> list = queryListTyped("allBatch",
				"rootBatchId", IntegerType.INSTANCE, catchBatch.getId(),
				"pmfmId", IntegerType.INSTANCE, pmfmId);
		Comparator<Batch> batchComparator = Batchs.newRankOrderComparator();

		// Remove possible duplicated batch (due to left join,...)

		List<SortingBatch> safeSortingBatchs = new ArrayList<SortingBatch>();

		Multimap<Integer, SortingBatch> batchesById = Multimaps.index(list, new Function<SortingBatch, Integer>() {
			@Override
			public Integer apply(SortingBatch input) {
				return input.getId();
			}
		});

		for (Integer sortingBatchId : batchesById.keySet()) {
			Collection<SortingBatch> sortingBatches = batchesById.get(sortingBatchId);
			if (sortingBatches.size() == 1) {
				safeSortingBatchs.add(sortingBatches.iterator().next());
			} else {

				// take the first with isReference = true
				// if not found then take the first one
				SortingBatch safeSortingBatch = null;
				for (SortingBatch sortingBatch : sortingBatches) {
					QuantificationMeasurement quantificationMeasurement = getQuantificationMeasurement(sortingBatch, pmfmId);
					if (quantificationMeasurement != null && quantificationMeasurement.getIsReferenceQuantification()) {
						safeSortingBatch = sortingBatch;
						break;
					}
				}
				if (safeSortingBatch == null) {

					// take the first
					safeSortingBatch = sortingBatches.iterator().next();
				}
				safeSortingBatchs.add(safeSortingBatch);
			}
		}

		// list of batch to check (their weight are coming from the samplingRatioText)
		// and could be remove if equals to the sum of their childs

		List<SortingBatch> sortingBatchsToCheck = new ArrayList<SortingBatch>();

		for (SortingBatch source : safeSortingBatchs) {
			session.evict(source);

			// compute weights
			boolean check = computeTechnicalWeights(source, pmfmId);
			if (check) {

				sortingBatchsToCheck.add(source);
			}

			// source.setChildBatchs(new TreeSet<Batch>(batchComparator));
			source.setChildBatchs(new TreeSet<Batch>(batchComparator));
			// error de all-delete-orphan ?? source.getChildBatchs().clear();
			Integer parentBatchId = source.getParentBatch().getId();
			// Add result into a maps
			sortingBatchById.put(source.getId(), source);
			if (parentBatchId != null) {
				parentBatchMapById.put(source.getId(), parentBatchId);
			}
		}

		// Retrieve the parent links for all batchs
		for (SortingBatch batch : sortingBatchById.values()) {
			// If retrieve the parent from the parent map
			Integer parentbatchId = parentBatchMapById.get(batch.getId());
			if (parentbatchId != null) {
				SortingBatch parentBatch = sortingBatchById.get(parentbatchId);

				// If found, link the batch with its parent :
				if (parentBatch != null) {
					batch.setParentBatch(parentBatch);
					parentBatch.getChildBatchs().add(batch);
				}

				// If no parent found, the batch should be a direct child of the catch batch
				else if (parentbatchId.equals(catchBatch.getId())) {
					catchBatch.getChildBatchs().add(batch);
				}
			}
		}

		if (!sortingBatchsToCheck.isEmpty()) {

			// for each batch
			// - compute indirect weights (sum of child weights)
			// - if weight equals the indirect weight then remove the weight
			// - remove computed indirect weights

			for (SortingBatch sortingBatch : sortingBatchsToCheck) {

				computeIndirectWeights(sortingBatch);
				cleanWeightIfNecessary(sortingBatch);
				removeIndirectWeights(sortingBatch);

			}

		}

		// Apply inheritance, starting with the catch batch children
		applyInheritance(catchBatch.getChildBatchs(), null, null, null, false, 1);

		if (logger.isDebugEnabled()) {
			logger.debug("end of loadFullTreeWithCache() - loading in "
					+ (System.currentTimeMillis() - time1)
					+ " ms.");
		}

		return catchBatch;
	}

	@Override
	public boolean isCatchBatchExistsForFishingOperation(Integer fishingOperationId) {
		Preconditions.checkNotNull(fishingOperationId);

		Integer catchBatchId = queryUniqueTyped("fishingOperationCatchBatchId",
				"fishingOperationId", IntegerType.INSTANCE, fishingOperationId);
		return catchBatchId != null;
	}

	@Override
	public Integer getIdByFishingOperationId(Integer fishingOperationId) {
		Preconditions.checkNotNull(fishingOperationId);

		Integer catchBatchId = queryUniqueTyped("fishingOperationCatchBatchId",
				"fishingOperationId", IntegerType.INSTANCE, fishingOperationId);
		if (catchBatchId == null) {
			throw new DataRetrievalFailureException("Unable to retrieve catch batch for fishing operation id=" + fishingOperationId);
		}
		return catchBatchId;
	}

	@Override
	public Integer getIdBySortingBatchId(Integer batchId) {
		Preconditions.checkNotNull(batchId);

		Integer catchBatchId = queryUniqueTyped("rootBatchId",
				"sortingBatchId", IntegerType.INSTANCE, batchId);
		if (catchBatchId == null) {
			throw new DataRetrievalFailureException("Unable to retrieve root catch batch for batch id=" + batchId);
		}
		return catchBatchId;
	}

	@Override
	public SortingBatch getSortingBatchById(CatchBatch catchBatch, Integer sortingBatchId) {
		Preconditions.checkNotNull(catchBatch);
		Preconditions.checkNotNull(sortingBatchId);
		Preconditions.checkNotNull(catchBatch.getSortingBatchById());

		SortingBatch sortingBatch = catchBatch.getSortingBatchById().get(sortingBatchId);
		if (sortingBatch == null) {
			throw new DataRetrievalFailureException(
					"Could not found batch with id="
							+ sortingBatchId
							+ " in the batch tree elements. Make sure the cache has been cleaned, since the last update of the tree.");
		}
		return sortingBatch;
	}

	@Override
	public QuantificationMeasurement setQuantificationMeasurement(
			Batch batch, Integer pmfmId, Integer recorderDepartmentId,
			Float weightValue, boolean isReferenceQuantitification) {
		QuantificationMeasurement quantificationMeasurement =
				getQuantificationMeasurement(batch, pmfmId);

		if (quantificationMeasurement == null) {

			// create it

			quantificationMeasurement = QuantificationMeasurement.Factory.newInstance();
			quantificationMeasurement.setBatch(batch);
			if (batch.getQuantificationMeasurements() == null) {
				batch.setQuantificationMeasurements(Sets.newHashSet(quantificationMeasurement));
			} else {
				batch.getQuantificationMeasurements().add(quantificationMeasurement);
			}
			quantificationMeasurement.setQualityFlag(load(
					QualityFlagImpl.class,
					QualityFlagCode.NOTQUALIFIED.getValue()));
			quantificationMeasurement.setDepartment(load(DepartmentImpl.class,
					recorderDepartmentId));
			quantificationMeasurement.setPmfm(load(PmfmImpl.class, pmfmId));
		}

		quantificationMeasurement.setNumericalValue(weightValue);
		quantificationMeasurement.setIsReferenceQuantification(isReferenceQuantitification);
		return quantificationMeasurement;
	}

	@Override
	public QuantificationMeasurement getQuantificationMeasurement(Batch batch, Integer pmfmId) {
		QuantificationMeasurement quantificationMeasurement = null;
		Collection<QuantificationMeasurement> measurements = batch.getQuantificationMeasurements();
		if (measurements != null) {

			// try by id
			for (QuantificationMeasurement qm : measurements) {
				if (pmfmId.equals(qm.getPmfm().getId())) {
					quantificationMeasurement = qm;
					break;
				}
			}
			if (quantificationMeasurement == null) {

				// let's take the first one with isReferenceQuantification to true
				for (QuantificationMeasurement qm : measurements) {
					if (qm.getIsReferenceQuantification()) {
						quantificationMeasurement = qm;
						break;
					}
				}
			}
		}
		return quantificationMeasurement;
	}

	@Override
	public SortingMeasurement getSortingMeasurement(
			SortingBatch sortingBatch, Integer pmfmId, Integer recorderDepartmentId,
			boolean createIfNotExists) {
		SortingMeasurement sortingMeasurement = null;
		if (sortingBatch.getSortingMeasurements() != null) {
			for (SortingMeasurement qm : sortingBatch
					.getSortingMeasurements()) {
				if (pmfmId.equals(qm.getPmfm().getId())) {
					sortingMeasurement = qm;
					break;
				}
			}
		}
		if (sortingMeasurement == null) {
			if (!createIfNotExists) {
				return null;
			}
			sortingMeasurement = SortingMeasurement.Factory
					.newInstance();
			sortingMeasurement.setSortingBatch(sortingBatch);
			if (sortingBatch.getSortingMeasurements() == null) {
				sortingBatch.setSortingMeasurements(Sets
						.newHashSet(sortingMeasurement));
				sortingMeasurement.setRankOrder(1);
			} else {
				sortingBatch.getSortingMeasurements().add(
						sortingMeasurement);
				sortingMeasurement.setRankOrder(sortingBatch.getSortingMeasurements().size());
			}
			sortingMeasurement.setQualityFlag(load(
					QualityFlagImpl.class,
					QualityFlagCode.NOTQUALIFIED.getValue()));
			sortingMeasurement.setDepartment(load(DepartmentImpl.class,
					recorderDepartmentId));
			sortingMeasurement.setPmfm(load(PmfmImpl.class, pmfmId));
		}

		return sortingMeasurement;
	}

	@Override
	public SortingMeasurement getInheritedSortingMeasurement(
			SortingBatch sortingBatch, Integer pmfmId) {
		if (sortingBatch.getInheritedSortingMeasurements() != null) {
			for (SortingMeasurement qm : sortingBatch
					.getInheritedSortingMeasurements()) {
				if (pmfmId.equals(qm.getPmfm().getId())) {
					return qm;
				}
			}
		}
		return null;
	}

	@Override
	public SortingBatch createSortingBatch(SortingBatch sortingBatch, CatchBatch parentCatchBatch) {
		SortingBatch result = sortingBatchDao.create(sortingBatch);

		// Refresh batch tree
		// refreshSortingBatchInBatchTree(result, parentCatchBatch);

		return result;
	}

	@Override
	public SortingBatch loadSortingBatch(Integer sortingBatchId, CatchBatch parentCatchBatch) {
		SortingBatch result = parentCatchBatch.getSortingBatchById().get(sortingBatchId);
		if (result == null) {
			result = sortingBatchDao.load(sortingBatchId);
		}
		return result;
	}

	@Override
	public void updateSortingBatch(SortingBatch sortingBatch, CatchBatch parentCatchBatch) {
		sortingBatchDao.update(sortingBatch);
	}

	@Override
	public void updateSortingBatch(List<SortingBatch> sortingBatchs, CatchBatch parentCatchBatch) {
		sortingBatchDao.update(sortingBatchs);
	}

	@Override
	public void setSortingSamplingRatio(SortingBatch sortingBatch,
			Float weight,
			Float weightBeforeSampling) {

		Preconditions.checkNotNull(sortingBatch);

		// Sampling Ratio
		if (weightBeforeSampling == null || weight == null) {
			sortingBatch.setSamplingRatio(null);
			sortingBatch.setSamplingRatioText(null);
		} else {
			String samplingRatioText = weight + "/" + weightBeforeSampling;
			samplingRatioText = samplingRatioText.replaceAll(",", ".");
			sortingBatch.setSamplingRatioText(samplingRatioText);
			sortingBatch.setSamplingRatio(weight / weightBeforeSampling);
		}

		// Update some technical fields :
		sortingBatch.setWeight(weight);
		sortingBatch.setWeightBeforeSampling(weightBeforeSampling);
		sortingBatch.setElevateWeight(null); // could not refresh it quickly
	}

	@Override
	public void setSortingBatchWeights(SortingBatch sortingBatch,
			Float weight,
			Float weightBeforeSampling,
			Integer weightPmfmId,
			Integer recorderDepartmentId) {

		Preconditions.checkNotNull(sortingBatch);

		// Sampling Ratio
		setSortingSamplingRatio(sortingBatch, weight, weightBeforeSampling);

		Collection<QuantificationMeasurement> quantificationMeasurements = sortingBatch.getQuantificationMeasurements();
		Set<QuantificationMeasurement> notChangedQuantificationMeasurements = Sets.newHashSet();
		if (quantificationMeasurements != null) {
			notChangedQuantificationMeasurements.addAll(quantificationMeasurements);
		}

		// Weight
		if (weightBeforeSampling != null || weight != null) {
			Float batchReferenceWeight = weight;
			if (batchReferenceWeight == null) {
				batchReferenceWeight = weightBeforeSampling;
			}
			QuantificationMeasurement qm = setQuantificationMeasurement(sortingBatch, weightPmfmId, recorderDepartmentId, batchReferenceWeight, true);

			// Update the weightMethodId technical field
			sortingBatch.setWeightMethodId(qm.getPmfm().getMethod().getId());

			notChangedQuantificationMeasurements.remove(qm);
		}
		// Removed not changed quantification measurements
		if (quantificationMeasurements != null) {
			quantificationMeasurements.removeAll(notChangedQuantificationMeasurements);
		}

		// Update some technical fields :
		sortingBatch.setWeight(weight);
		sortingBatch.setWeightBeforeSampling(weightBeforeSampling);
		sortingBatch.setElevateWeight(null); // could not refresh it quickly
	}

	@Override
	public void setSortingBatchReferenceTaxon(String batchId, Integer referenceTaxonId) {
		Preconditions.checkNotNull(batchId);
		Preconditions.checkNotNull(referenceTaxonId);

		if (logger.isDebugEnabled()) {
			logger.debug("Changing reference taxon for batch id=" + batchId);
		}

		int rowUpdated = queryUpdate("updateSortingBatchReferenceTaxon",
				"sortingBatchId", IntegerType.INSTANCE, Integer.valueOf(batchId),
				"referenceTaxonId", IntegerType.INSTANCE, referenceTaxonId);
		Preconditions.checkArgument(rowUpdated == 1, "Unable to update batch reference taxon.");
	}

	// ------------------------------------------------------------------------//
	// -- Internal methods --//
	// ------------------------------------------------------------------------//

	protected void applyInheritance(Collection<Batch> batchs,
			List<SortingMeasurement> inheritedSortingMeasurements,
			Integer inheritedTaxonGroupId,
			Integer inheritedReferenceTaxonId,
			boolean inheritedExhaustiveInventory,
			int treeLevel) {
		if (batchs == null || batchs.size() == 0) {
			return;
		}
		for (Batch notCastedBatch : batchs) {
			SortingBatch batch = (SortingBatch) notCastedBatch;
			// Apply sorting measurements inheritance, if need
			if (inheritedSortingMeasurements != null && inheritedSortingMeasurements.size() > 0) {
				batch.getInheritedSortingMeasurements().clear();
				batch.getInheritedSortingMeasurements().addAll(inheritedSortingMeasurements);
			}

			// Apply taxon group and reference taxon inheritance, if need
			if (batch.getReferenceTaxon() == null && inheritedReferenceTaxonId != null) {
				batch.setInheritedReferenceTaxonId(inheritedReferenceTaxonId);
			}
			if (batch.getTaxonGroup() == null && inheritedTaxonGroupId != null) {
				batch.setInheritedTaxonGroupId(inheritedTaxonGroupId);
			}

			// Exhaustive inventory inheritance, if need
			if (inheritedExhaustiveInventory) {
				batch.setExhaustiveInventory(inheritedExhaustiveInventory);
			} else {
				batch.setExhaustiveInventory(false);
			}

			batch.setTreeLevel((short) treeLevel);

			if (batch.getChildBatchs() != null && batch.getChildBatchs().size() > 0) {
				List<SortingMeasurement> newInheritedSortingMeasurement = Lists.newArrayList();
				if (inheritedSortingMeasurements != null) {
					newInheritedSortingMeasurement.addAll(inheritedSortingMeasurements);
				}
				newInheritedSortingMeasurement.addAll(batch.getSortingMeasurements());

				// Recursive call : propagate species and sorted/unsorted value
				applyInheritance(batch.getChildBatchs(),
						newInheritedSortingMeasurement,
						batch.getTaxonGroup() == null ? null : batch.getTaxonGroup().getId(),
						batch.getReferenceTaxon() == null ? null : batch.getReferenceTaxon().getId(),
						batch.isExhaustiveInventory(),
						treeLevel + 1);
			}

		}
	}

	protected void computeTechnicalWeights(CatchBatch batch, Integer pmfmId) {

		QuantificationMeasurement qm = getQuantificationMeasurement(batch, pmfmId);
		if (qm != null) {
			Float weight = qm.getNumericalValue();
			batch.setWeightMethodId(qm.getPmfm().getMethod().getId());
			batch.setWeight(weight);
		}

	}

	protected boolean computeTechnicalWeights(SortingBatch batch, Integer pmfmId) {
		Float weight = null;

		boolean check = false;

		// Retrieve the reference weight, and weight method
		QuantificationMeasurement qm = getQuantificationMeasurement(batch, pmfmId);
		if (qm != null) {
			weight = qm.getNumericalValue();
			batch.setWeightMethodId(qm.getPmfm().getMethod().getId());
		}

		String samplingRatioText = batch.getSamplingRatioText();

		if (weight == null) {

			// no quantification measurement on the node
			// may try to use the samplingRatioText to decode weight
			// We only do this for a sortingBatch

			if (samplingRatioText != null) {

				String startStr = StringUtils.substringBefore(samplingRatioText, "/").trim();
				weight = Float.parseFloat(startStr);

				String endStr = StringUtils.substringAfter(samplingRatioText, "/").trim();
				if (!endStr.isEmpty()) {
					batch.setWeightBeforeSampling(Float.parseFloat(endStr));

					if (startStr.equals(endStr)) {

						// special case : redundant weights, there is no sampling, so only keep the weightBeforeSampling
						weight = null;

					}
				}

				batch.setWeight(weight);

				// Need to check if some could be removed
				check = true;

			}

		} else {

			Float samplingRatio = batch.getSamplingRatio();

			// Parse samplingRatioText to get the exact value of weightBeforeSampling
			String startStr = weight.toString().replace(',', '.') + "/";
			if (samplingRatioText != null && samplingRatioText.startsWith(startStr)) {
				String weightStr = samplingRatioText.substring(startStr.length());
				if (!weightStr.isEmpty()) {
					batch.setWeightBeforeSampling(Float.parseFloat(weightStr));
				}
			}

			// Or compute weightBeforeSampling, using the samplingRatio - bad precision ;(
			else if (samplingRatio != null) {
				batch.setWeightBeforeSampling(weight / samplingRatio);
			}
			batch.setWeight(weight);

		}

		return check;

	}

	protected void computeIndirectWeights(Batch batch) {

		if (CollectionUtils.isEmpty(batch.getChildBatchs())) {

			// no child, indirectWeight is weightBeforeSampling or weight
			if (batch.getWeightBeforeSampling() == null) {
				batch.setIndirectWeight(batch.getWeight());
			} else {
				batch.setIndirectWeight(batch.getWeightBeforeSampling());
			}

			if (batch.getIndirectWeight() == null) {

				if (log.isDebugEnabled()) {
					log.debug("No indirect weight computed for batch " + batch.getId());
				}

			}

		} else {

			float parentWeight = 0f;

			// alway treat child before parent
			for (Batch childBatch : batch.getChildBatchs()) {

				computeIndirectWeights(childBatch);
				Float indirectWeight = childBatch.getIndirectWeight();

				// We can't garantee that the weight is not null
				// We could make it not null (in the first block above but I feel more
				// confident to let the weight null, will be more efficient later to find out
				// why it is then null (abosrbing zero value is a bad limit case))
				if (indirectWeight != null) {

					parentWeight += indirectWeight;

				}

			}

			batch.setIndirectWeight(parentWeight);

		}

	}

	protected void cleanWeightIfNecessary(Batch sortingBatch) {

		Float weight = sortingBatch.getWeight();
		Float indirectWeight = sortingBatch.getIndirectWeight();

		if (weight != null) {

			// check if weight can be removed
			if (Math.abs(weight - indirectWeight) < 0.001) {

				// same weight
				// this means we can remove the weight
				sortingBatch.setWeight(null);

			}

		}

	}

	protected void removeIndirectWeights(Batch batch) {

		batch.setIndirectWeight(null);

		if (CollectionUtils.isNotEmpty(batch.getChildBatchs())) {

			for (Batch childBatch : batch.getChildBatchs()) {

				removeIndirectWeights(childBatch);

			}

		}
	}

	protected void getAllChildrenIds(Integer batchId, List<Integer> result) {
		Iterator<Object[]> childRows = queryIteratorTyped("childBatchIds",
				"parentBatchId", IntegerType.INSTANCE, batchId);
		while (childRows.hasNext()) {
			Object[] childRow = childRows.next();
			Integer childBatchId = (Integer) childRow[0];

			getAllChildrenIds(childBatchId, result);
		}
		result.add(batchId);
	}
}