package fr.ifremer.adagio.core.dao.data.batch;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: Batchs.java 12090 2014-05-20 22:03:12Z bl05b3e $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/trunk/adagio/core-allegro/src/main/java/fr/ifremer/adagio/core/dao/data/batch/CatchBatchDaoImpl.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.Serializable;
import java.util.Comparator;

/**
 * Useful methos around {@link Batch}.
 * <p/>
 * Created on 4/22/14.
 * 
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 3.5.2
 */
public class Batchs {

	public static Comparator<Batch> newRankOrderComparator() {
		return new BatchRankOrderComparator();
	}

	public static class BatchRankOrderComparator implements Comparator<Batch>, Serializable {

		private static final long serialVersionUID = 1L;

		@Override
		public int compare(Batch b1, Batch b2) {
			return (b1.getRankOrder() == null) ? 0 : b1.getRankOrder().compareTo(b2.getRankOrder());
		}
	}
}
