// Generated by: hibernate/SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.administration.user;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;

import org.hibernate.SessionFactory;
import org.hibernate.dialect.Dialect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Repository;

import com.google.common.base.Preconditions;

import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.synchro.dao.Daos;

/**
 * @see fr.ifremer.adagio.core.dao.administration.user.PersonSession
 */
@Repository("personSessionDao")
@Lazy
public class PersonSessionDaoImpl
		extends PersonSessionDaoBase
		implements PersonSessionExtendDao
{

	/**
	 * @see oracle.jdbc.OracleTypes.CURSOR
	 */
	private final int ORACLE_TYPE_CURSOR = -10;

	/**
	 * Constructor used by Spring
	 */
	@Autowired
	public PersonSessionDaoImpl(SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

	/**
	 * Constructor use without Spring (i.e. for synchro)
	 */
	public PersonSessionDaoImpl() {
		super();
	}

	@Override
	public int initPersonSession(Properties connectionProperties, int userId) {
		Preconditions.checkArgument(Daos.isOracleDatabase(Daos.getUrl(connectionProperties)),
				"Not implemented yet for non-Oracle database connection.");

		Connection connection = null;
		try {
			connection = Daos.createConnection(connectionProperties);
		} catch (SQLException e) {
			throw new AdagioTechnicalException("Could not connect to given database", e);
		}

		try {
			return initPersonSession(connection, userId);
		} finally {
			Daos.closeSilently(connection);
		}

	}

	protected int initPersonSession(Connection connection, int userId) {
		CallableStatement statement = null;
		try {

			statement = connection.prepareCall("{? = call F_FILL_PERSON_SESSION(?)}");
			statement.registerOutParameter(1, ORACLE_TYPE_CURSOR);
			statement.setLong(2, (long) userId);
			// statement.setInt(3, 1); // 1=skip long duration generation
			statement.execute();
			ResultSet rs = (ResultSet) statement.getObject(1);
			rs.next();
			int personSessionId = rs.getInt(1);
			if (personSessionId == 0) {
				throw new DataRetrievalFailureException(
						String.format("Could not compute PERSON_SESSION for user with id=%s. Make sure this user exists in table PERSON.", userId));
			}

			return personSessionId;
		} catch (SQLException e) {
			throw new AdagioTechnicalException("Error while executing function F_FILL_PERSON_SESSION.", e);
		} finally {
			Daos.closeSilently(statement);
		}

	}

}