package fr.ifremer.adagio.core.dao.administration.user;

import java.util.Properties;

import javax.transaction.Transactional;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: PersonExtendDao.java 12554 2015-01-12 13:16:58Z tc1fbb1 $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.8.2/core-allegro/src/main/java/fr/ifremer/adagio/core/dao/administration/user/PersonExtendDao.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

public interface PersonExtendDao extends PersonDao {

	Person createAsTemporary(String lastname, String firstname, Integer departmentId);

	/**
	 * Method used to get the user ID, from a username.
	 * <p/>
	 * This method allow a used outside Spring context, using the given connection properties.
	 * 
	 * @param connectionProperties
	 * @param username
	 *            The user login (PERSON.USERNAME or PERSON.USERNAME_EXTRANET)
	 * @return the value of the column PERSON.ID
	 */
	Integer getUserIdByUsername(Properties connectionProperties, String username);

	/**
	 * Method used to get the user ID, from a username.
	 * <p/>
	 * This method use the default dataSource bean.
	 * 
	 * @param connectionProperties
	 * @param username
	 *            The user login (PERSON.USERNAME or PERSON.USERNAME_EXTRANET)
	 * @return the value of the column PERSON.ID
	 */
	Integer getUserIdByUsername(String username);

}
