// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringHibernateDaoImpl.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.administration.user;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: PersonDaoImpl.java 12431 2014-11-21 15:55:30Z bl05b3e $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.8.2/core-allegro/src/main/java/fr/ifremer/adagio/core/dao/administration/user/PersonDaoImpl.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.hibernate.Session;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;

import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.StatusCode;
import fr.ifremer.adagio.core.dao.referential.StatusImpl;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import fr.ifremer.adagio.core.dao.technical.hibernate.TemporaryDataHelper;

/**
 * @see fr.ifremer.adagio.core.dao.administration.user.Person
 */
@org.springframework.stereotype.Repository("personDao")
@org.springframework.context.annotation.Lazy
public class PersonDaoImpl
		extends fr.ifremer.adagio.core.dao.administration.user.PersonDaoBase
		implements PersonExtendDao {

	protected DataSource dataSource;

	@Resource
	protected AdagioConfiguration config;

	/**
	 * Constructor used by Spring
	 */
	@org.springframework.beans.factory.annotation.Autowired
	public PersonDaoImpl(org.hibernate.SessionFactory sessionFactory, DataSource dataSource) {
		super();
		setSessionFactory(sessionFactory);
		this.dataSource = dataSource;
	}

	/**
	 * Constructor used without Spring
	 */
	public PersonDaoImpl() {
		super();
		this.dataSource = null;
		this.config = AdagioConfiguration.getInstance();
	}

	/**
	 * Constructor used without Spring
	 */
	public PersonDaoImpl(DataSource dataSource) {
		super();
		this.dataSource = dataSource;
	}

	@Override
	public Person createAsTemporary(String lastname, String firstname, Integer departmentId) {
		Session session = getSession();

		Integer personId = TemporaryDataHelper.getNewNegativeIdForTemporaryData(session, PersonImpl.class);

		// Fill the adagio entity
		fr.ifremer.adagio.core.dao.administration.user.Person target = fr.ifremer.adagio.core.dao.administration.user.Person.Factory.newInstance();
		target.setId(personId);
		target.setLastname(lastname);
		target.setFirstname(firstname);
		target.setDepartment(load(DepartmentImpl.class, departmentId));
		target.setCreationDate(new Date());
		target.setStatus(load(StatusImpl.class, StatusCode.TEMPORARY.getValue()));

		// Add a profil 'user'
		// LP 16/10/2014: profil 'user' does not exists any more in USER_PROFIL table. change to 'observer'
		UserProfil userProfil = load(UserProfilImpl.class, UserProfilId.OBSERVER.getValue());
		target.setProfils(Sets.newHashSet(userProfil));

		target = create(target);

		return target;
	}

	@Override
	public Integer getUserIdByUsername(Properties connectionProperties, String username) {
		// Find the user, by username
		Connection connection = null;
		try {
			connection = createConnection(connectionProperties);
			return getUserIdByUsername(connection, username);
		} catch (SQLException e) {
			throw new DataRetrievalFailureException("Error while getting user id from username: " + e.getMessage(), e);
		} finally {
			closeSilently(connection);
		}
	}

	@Override
	public Integer getUserIdByUsername(String username) {
		Preconditions.checkNotNull(dataSource);

		// Find the user, by username
		Connection connection = null;
		try {
			connection = DataSourceUtils.getConnection(dataSource);
			return getUserIdByUsername(connection, username);
		} finally {
			DataSourceUtils.releaseConnection(connection, dataSource);
		}
	}

	/* -- Internal methods -- */

	protected Integer getUserIdByUsername(Connection connection, String username) {
		// Find the user, by username
		String sql = String.format("SELECT ID FROM PERSON WHERE (USERNAME='%s' OR USERNAME_EXTRANET='%s') AND STATUS_FK='%s'",
				username,
				username,
				StatusCode.ENABLE.getValue());

		Object value = DaoUtils.sqlUniqueOrNull(connection, sql);
		if (value == null) {
			return null;
		}

		// Adagio / Oracle DBMS return a BigDecimal from NUMBER(10) columns
		if (value instanceof BigDecimal) {
			return ((BigDecimal) value).intValue();
		}

		// for other java types: convert into Integer
		return Integer.parseInt(value.toString());
	}

	protected Connection createConnection(Properties connectionProperties) throws SQLException {
		Preconditions.checkNotNull(connectionProperties);

		String jdbcUrl = DaoUtils.getUrl(connectionProperties);
		if (dataSource != null && isDataSourceUrl(jdbcUrl)) {
			return DataSourceUtils.getConnection(dataSource);
		}
		return DaoUtils.createConnection(connectionProperties);
	}

	protected void closeSilently(Connection connection) {
		Preconditions.checkNotNull(connection);

		String jdbcUrl;
		try {
			jdbcUrl = connection.getMetaData().getURL();
			if (dataSource != null && isDataSourceUrl(jdbcUrl)) {
				DataSourceUtils.releaseConnection(connection, dataSource);
				return;
			}
		} catch (SQLException e) {
			// continue
		}

		DaoUtils.closeSilently(connection);
	}

	/**
	 * Need to be able to use dataSource connection, event if connectionProperties are given.
	 * <p/>
	 * This is need to be able to use this DAO with AND without Spring, and with different kind of dataSource. e.g.
	 * <ul>
	 * <li>adagio-core-allegro-ui module use an Oracle dataSource (URL=config.getImportJdbcUrl());
	 * <li>but adagio-core-allegro use a HsqlDB dataSource (URL=config.getJdbcUrl());
	 * <li>and some actions use directly connectionProperties (no dataSource started)
	 * </ul>
	 * 
	 * @param jdbcUrl
	 * @return
	 */
	protected boolean isDataSourceUrl(String jdbcUrl) {
		return config.getJdbcURL().equals(jdbcUrl);
	}

}