// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/search/Search.java.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

/**
 * Stores the information necessary to perform a property search.
 *
 * @see PropertySearch
 */
public class Search
    implements Serializable
{
    private static final long serialVersionUID = 8277265070757689152L;

    /**
     * Constructs the search object.
     *
     * @param parametersIn the parameters to use.
     * @param pageNumberIn the page number (if paging results).
     * @param pageSizeIn the page size (if paging results).
     * @param eagerFetchingIn whether or not the search will eagerly fetch the associations included in the search.
     */
    public Search(SearchParameter[] parametersIn, int pageNumberIn, int pageSizeIn, boolean eagerFetchingIn)
    {
        this.pageNumber = pageNumberIn;
        this.pageSize = pageSizeIn;
        if (parametersIn != null)
        {
            this.parameters.addAll(Arrays.asList(parametersIn));
        }
        this.eagerFetching = eagerFetchingIn;
    }

    /**
     * Constructs the search object.
     *
     * @param parametersIn the parameters to use.
     * @param pageNumberIn the page number (if paging results).
     * @param pageSizeIn the page size (if paging results).
     */
    public Search(SearchParameter[] parametersIn, int pageNumberIn, int pageSizeIn)
    {
        this(parametersIn, pageNumberIn, pageSizeIn, false);
    }

    /**
     * Constructs the search object.
     *
     * @param parametersIn the parameters to use.
     */
    public Search(SearchParameter[] parametersIn)
    {
        this(parametersIn, -1, -1, false);
    }

    /**
     * Constructs the search object.
     *
     * @param parametersIn the parameters to use.
     * @param eagerFetchingIn whether or not the search will eagerly fetch the associations included in the search.
     */
    public Search(SearchParameter[] parametersIn, boolean eagerFetchingIn)
    {
        this(parametersIn, -1, -1, eagerFetchingIn);
    }

    private int pageNumber;

    /**
     * Gets the page number (if paging the results).
     *
     * @return the page number.
     */
    public int getPageNumber()
    {
        return this.pageNumber;
    }

    /**
     * Sets the page number (if paging the results).
     *
     * @param pageNumberIn the page number (if paging results).
     * @return the current search instance.
     */
    public Search setPageNumber(int pageNumberIn)
    {
        this.pageNumber = pageNumberIn;
        return this;
    }

    private int pageSize;

    /**
     * Gets the size of the page (if paging the results).
     *
     * @return the page size.
     */
    public int getPageSize()
    {
        return this.pageSize;
    }

    /**
     * Sets the size of the page (if paging the results).
     *
     * @param pageSizeIn the page size.
     * @return the current search instance.
     */
    public Search setPageSize(int pageSizeIn)
    {
        this.pageSize = pageSizeIn;
        return this;
    }

    private Collection<SearchParameter> parameters = new ArrayList<SearchParameter>();

    /**
     * Gets the search parameters for this search object..
     * @return parameters.toArray(new SearchParameter[this.parameters.size()])
     */
    public SearchParameter[] getParameters()
    {
        return this.parameters.toArray(new SearchParameter[this.parameters.size()]);
    }

    /**
     * Sets the search parameters for this search object.
     *
     * @param parametersIn
     * @return the current search instance (this).
     */
    public Search setParameters(SearchParameter[] parametersIn)
    {
        this.parameters = new ArrayList<SearchParameter>(Arrays.asList(parametersIn));
        return this;
    }

    /**
     * Constructs the search object with no parameters.
     */
    public Search()
    {
        this(null, -1, -1, false);
    }

    /**
     * Adds a search parameter to the search.
     *
     * @param searchParameter the search parameter to add.
     * @return the current search instance.
     */
    public Search addSearchParameter(final SearchParameter searchParameter)
    {
        this.parameters.add(searchParameter);
        return this;
    }

    private boolean eagerFetching;

    /**
     * Whether or not eager fetching is enabled (if it is enabled, all associations
     * queried will be fetched eagerly).
     *
     * @return true/false
     */
    public boolean isEagerFetching()
    {
        return this.eagerFetching;
    }

    /**
     * Sets whether or not eager fetching is enabled (if it is enabled, all associations
     * queried will be fetched eagerly).
     *
     * @param eagerFetchingIn whether or not to eager fetch the results.
     * @return the current search instance (this).
     */
    public Search setEagerFetching(boolean eagerFetchingIn)
    {
        this.eagerFetching = eagerFetchingIn;
        return this;
    }

    /**
     * Adds an "order by" clause for the search with default ascending order.
     *
     * @param propertyName the property name to order by.
     *
     * @return the current search instance.
     */
    public Search addOrderBy(final String propertyName)
    {
        return this.addOrderBy(propertyName, SearchParameter.ORDER_ASC);
    }

    /**
     * Adds an "order by" clause for the search.
     *
     * @param propertyName the property name to order by.
     * @param order the order.  Use: {@link SearchParameter#ORDER_ASC},
     *        {@link SearchParameter#ORDER_DESC}, or {@link SearchParameter#ORDER_UNSET}.
     *
     * @return the current search instance.
     */
    public Search addOrderBy(final String propertyName, final int order)
    {
        this.parameters.add(new SearchParameter(propertyName, null, -1, -1, order));
        return this;
    }

    /**
     * Adds an "order by" clause for the search.
     *
     * @param propertyName the property name to order by.
     * @param descending true/false; true for descending ordering, false for ascending ordering.
     *
     * @return the current search instance.
     */
    public Search addOrderBy(String propertyName, final boolean descending)
    {
        this.addOrderBy(propertyName, descending ? SearchParameter.ORDER_DESC : SearchParameter.ORDER_ASC);
        return this;
    }

    private boolean useSqlLimiting = false;

    /**
     * Whether or not to use sql limiting (if paging is being used).  If this is set to false, then
     * paging will be based on the actual entities returned instead of using SQL to limit the results.
     *
     * @return true/false
     */
    public boolean isUseSqlLimiting()
    {
        return this.useSqlLimiting;
    }

    /**
     * Sets whether or not to use sql limiting (if paging is being used).  If this is set to false, then
     * paging will be based on the actual entities returned instead of using SQL to limit the results.
     *
     * @param useSqlPaging whether or not to use SQL paging (default is <code>false</code>).
     *
     * @return the current search instance.
     */
    public Search setUseSqlLimiting(boolean useSqlPaging)
    {
        this.useSqlLimiting = useSqlPaging;
        return this;
    }
}