package fr.ifremer.adagio.core.config;

/*
 * #%L
 * SIH-Adagio :: Shared
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.nuiton.config.ConfigActionDef;

import fr.ifremer.adagio.core.action.AllegroCoreHelpAction;
import fr.ifremer.adagio.core.action.AllegroCoreImportDataAction;
import fr.ifremer.adagio.core.action.AllegroCoreImportReferentialAction;
import fr.ifremer.adagio.core.action.AllegroCoreNewEmptyDbAction;
import fr.ifremer.adagio.core.action.DatabaseChangeLogAction;
import fr.ifremer.adagio.core.action.DatabaseDiffAction;
import fr.ifremer.adagio.core.action.DatabaseStatusAction;
import fr.ifremer.adagio.core.action.DatabaseUpdateAction;

public enum AllegroCoreConfigurationAction implements ConfigActionDef {

	HELP(AllegroCoreHelpAction.class.getName() + "#show", "-h", "--help"),

	DB_UPDATE(DatabaseUpdateAction.class.getName() + "#run", "--schema-update"),

	DB_STATUS(DatabaseStatusAction.class.getName() + "#run", "--schema-status"),

	DB_DIFF(DatabaseDiffAction.class.getName() + "#run", "--schema-diff"),

	DB_CHANGELOG(DatabaseChangeLogAction.class.getName() + "#run", "--schema-changelog"),

	DB_IMPORT_REF(AllegroCoreImportReferentialAction.class.getName() + "#run", "--import-ref"),

	DB_IMPORT_DATA(AllegroCoreImportDataAction.class.getName() + "#run", "--import-data"),

	NEW_EMPTY_DB(AllegroCoreNewEmptyDbAction.class.getName() + "#run", "--new-db");

	public String action;
	public String[] aliases;

	private AllegroCoreConfigurationAction(String action, String... aliases) {
		this.action = action;
		this.aliases = aliases;
	}

	@Override
	public String getAction() {
		return action;
	}

	@Override
	public String[] getAliases() {
		return aliases;
	}
}
