package fr.ifremer.adagio.core.action;

/*
 * #%L
 * SIH-Adagio :: Shared
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.File;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.DatabaseSchemaDao;
import fr.ifremer.adagio.core.dao.technical.hibernate.DatabaseSchemaDaoImpl;

public class AllegroCoreNewEmptyDbAction {
	/* Logger */
	private static final Log log = LogFactory.getLog(AllegroCoreNewEmptyDbAction.class);

	public void run() {
		AdagioConfiguration config = AdagioConfiguration.getInstance();

		// Check output directory validity
		File outputDirectory = ActionUtils.checkAndGetOutputFile(true, this.getClass());

		DatabaseSchemaDao databaseSchemaDao = new DatabaseSchemaDaoImpl(config);

		try {
			// Create the database
			databaseSchemaDao.generateNewDb(outputDirectory, false);
		} catch (AdagioTechnicalException e) {
			log.error(e.getMessage());
		}

		// Set this new db directory as default database
		// This allow to chain action. e.g. --new-db --import-ref
		config.setDbDirectory(outputDirectory);
	}
}
