// license-header java merge-point
// Generated by: paging/PaginaionResult.java.vsl in andromda-spring-cartridge.
package org.andromda.spring;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.Serializable;

/**
 * A class that represents a "paged result" of data out of a larger set, ie.
 * a list of objects together with info to indicate the starting row and
 * the full size of the dataset.
 * Generated by paging/PaginationResult.vsl in andromda-spring cartridge
 */
public class PaginationResult
    implements Serializable
{
    private static final long serialVersionUID = 8766771253773009362L;

    private long totalSize;
    private Object[] data;

    /**
     * Create an object representing a sublist of a dataset.
     *
     * @param dataIn is a list of consecutive objects from the dataset.
     * @param totalSizeIn is the total number of matching rows available.
     */
    public PaginationResult(
        Object[] dataIn,
        long totalSizeIn)
    {
        this.data = dataIn;
        this.totalSize = totalSizeIn;
    }

    /**
     * Returns the number of items in the entire result.
     *
     * @return the total size of items.
     */
    public long getTotalSize()
    {
        return this.totalSize;
    }

    /**
     * Sets the total size of this pagination's complete set.
     *
     * @param totalSizeIn the total size of objects contained in the complete set.
     */
    public void setTotalSize(long totalSizeIn)
    {
        this.totalSize = totalSizeIn;
    }

    /**
     * Return the array of objects held by this pagination rules, which
     * is a continuous subset of the full dataset.
     * @return this.data
     */
    public Object[] getData()
    {
        return this.data;
    }

    /**
     * Sets the data for this pagination result.
     *
     * @param dataIn the subset of paginated data.
     */
    public void setData(Object[] dataIn)
    {
        this.data = dataIn;
    }
}