package fr.ifremer.adagio.core.service.technical.synchro.data;

/*
 * #%L
 * Tutti :: Persistence
 * $Id: ReferentialSynchroService.java 1573 2014-02-04 16:41:40Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/trunk/tutti-persistence/src/main/java/fr/ifremer/adagio/core/service/technical/synchro/ReferentialSynchroService.java $
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.File;
import java.util.Properties;

import org.hibernate.dialect.Dialect;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.google.common.base.Predicate;

/**
 * Created on 1/14/14.
 * 
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 3.0
 */
@Transactional(readOnly = true, propagation = Propagation.NOT_SUPPORTED)
public interface DataSynchroService {

	/**
	 * Get the db connexion informations for the internal data source.
	 * 
	 * @return the db connexion for the internal data source
	 */
	Properties getLocalConnectionProperties();

	/**
	 * Gets the dialect used by the local database.
	 * 
	 * @return the dialect used by the local database.
	 */
	Dialect getLocalDialect();

	/**
	 * Prepare the synchronize operation from the local data database supported
	 * by this service, says just compute nb rows to update for each table and
	 * update the result model.
	 * 
	 * @param remoteConnectionProperties
	 *            connection properties of the remote
	 *            database used to synchronize referential
	 * @param result
	 *            result of the operation
	 */
	void prepare(Properties remoteConnectionProperties, Properties localConnectionProperties,
			DataSynchroResult result, Predicate<String> tableFilter);

	/**
	 * Launch the synchronize operation from the local data database supported
	 * by this service.
	 * 
	 * @param remoteConnectionProperties
	 *            connection properties of the remote
	 *            database used to synchronize referential
	 * @param result
	 *            model
	 */
	void synchronize(Properties remoteConnectionProperties, Properties localConnectionProperties,
			DataSynchroResult result, Predicate<String> tableFilter);

	void prepare(File dbDirectory, DataSynchroResult result, Predicate<String> tableFilter);

	void synchronize(File dbDirectory, DataSynchroResult result, Predicate<String> tableFilter);
}
