package fr.ifremer.adagio.core.service.technical.synchro;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;

import java.io.File;
import java.util.Properties;
import java.util.Set;

/**
 * Created on 4/21/14.
 * 
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 3.5
 */
public class ReferentialSynchroContext {

	public static ReferentialSynchroContext newContext(Set<String> tablesToSynch,
			Properties remoteConnectionProperties,
			ReferentialSynchroResult result) {
		ReferentialSynchroContext context = new ReferentialSynchroContext();
		context.setTablesToSynch(tablesToSynch);
		context.setRemoteConnectionProperties(remoteConnectionProperties);
		context.setResult(result);
		return context;
	}

	public static ReferentialSynchroContext newContext(Set<String> tablesToSynch,
			File dbDirectory,
			ReferentialSynchroResult result) {

		Properties remoteConnectionProperties = new Properties();
		AdagioConfiguration config = AdagioConfiguration.getInstance();

		String jdbcUrl = DaoUtils.getJdbcUrl(dbDirectory,
				config.getDbName());

		DaoUtils.fillConnectionProperties(remoteConnectionProperties,
				jdbcUrl,
				config.getJdbcUsername(),
				config.getJdbcPassword());
		ReferentialSynchroContext context = new ReferentialSynchroContext();
		context.setTablesToSynch(tablesToSynch);
		context.setRemoteConnectionProperties(remoteConnectionProperties);
		context.setResult(result);
		return context;
	}

	protected Set<String> tablesToSynch;

	protected Properties remoteConnectionProperties;

	protected ReferentialSynchroResult result;

	public Set<String> getTablesToSynch() {
		return tablesToSynch;
	}

	public void setTablesToSynch(Set<String> tablesToSynch) {
		this.tablesToSynch = tablesToSynch;
	}

	public Properties getRemoteConnectionProperties() {
		return remoteConnectionProperties;
	}

	public void setRemoteConnectionProperties(Properties remoteConnectionProperties) {
		this.remoteConnectionProperties = remoteConnectionProperties;
	}

	public ReferentialSynchroResult getResult() {
		return result;
	}

	public void setResult(ReferentialSynchroResult result) {
		this.result = result;
	}
}
