package fr.ifremer.adagio.core.service.technical.sanity.task;

/*
 * #%L
 * Tutti :: Persistence
 * $Id: DatabaseSanityTaskVesselRegistrationPeriod.java 1573 2014-02-04 16:41:40Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/trunk/tutti-persistence/src/main/java/fr/ifremer/adagio/core/service/technical/sanity/task/DatabaseSanityTaskVesselRegistrationPeriod.java $
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.List;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.Session;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import fr.ifremer.adagio.core.dao.data.vessel.VesselRegistrationPeriod;
import fr.ifremer.adagio.core.dao.data.vessel.VesselRegistrationPeriodImpl;

/**
 * Check that vessel registration periods are sane.
 * <p/>
 * Created on 1/18/14.
 * 
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 3.5
 */
public class DatabaseSanityTaskVesselRegistrationPeriod implements DatabaseSanityTask {

	/** Logger. */
	private static final Log log = LogFactory.getLog(DatabaseSanityTaskVesselRegistrationPeriod.class);

	@Override
	public Set<String> sanity(Session currentSession) {

		Set<String> cacheIds = Sets.newHashSet();

		// get all VESSEL_REGISTRATION_PERIOD with more than one unclosed period
		Query query = currentSession.createQuery(
				"SELECT vesselRegistrationPeriodPk.vessel.code FROM " +
						VesselRegistrationPeriodImpl.class.getName()
						+ " WHERE endDateTime IS NULL GROUP BY vesselRegistrationPeriodPk.vessel.code HAVING COUNT(*)>1");
		List<String> vesselCodes = query.list();

		if (CollectionUtils.isEmpty(vesselCodes)) {
			if (log.isInfoEnabled()) {
				log.info("vesselRegistrationPeriods are sane");
			}
			return cacheIds;
		}

		for (String vesselCode : vesselCodes) {

			// Get all features having a null endDatetime
			Query query1 = currentSession
					.createQuery(
							"SELECT vesselRegistrationPeriodPk FROM "
									+ VesselRegistrationPeriodImpl.class.getName()
									+
									" WHERE endDateTime IS NULL AND vesselRegistrationPeriodPk.vessel.code = :vesselCode ORDER BY vesselRegistrationPeriodPk.startDateTime DESC")
					.setString("vesselCode", vesselCode);

			List<VesselRegistrationPeriod> vesselRegistrationPeriods = Lists.<VesselRegistrationPeriod> newArrayList(query1.list());

			// remove first id (this one will stay on db)
			vesselRegistrationPeriods.remove(0);

			// remove all others ids
			if (log.isWarnEnabled()) {
				log.warn(String.format("Remove %d bad VesselRegistrationPeriod for vessel: %s",
						vesselRegistrationPeriods.size(), vesselCode));
			}
			currentSession.createQuery(
					"DELETE FROM " + VesselRegistrationPeriodImpl.class.getName()
							+ " WHERE vesselRegistrationPeriodPk in :vesselRegistrationPeriodPk").
					setParameterList("vesselRegistrationPeriodPk", vesselRegistrationPeriods).executeUpdate();
		}

		currentSession.setFlushMode(FlushMode.COMMIT);
		currentSession.flush();

		// clean vessel caches
		// clean vessel caches
		cacheIds.add("fishingVessels");
		cacheIds.add("vesselByCode");

		return cacheIds;
	}
}
