package fr.ifremer.adagio.core.service.technical.sanity.task;

/*
 * #%L
 * Tutti :: Persistence
 * $Id: DatabaseSanityTaskVesselOwnerPeriod.java 1573 2014-02-04 16:41:40Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/trunk/tutti-persistence/src/main/java/fr/ifremer/adagio/core/service/technical/sanity/task/DatabaseSanityTaskVesselOwnerPeriod.java $
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.List;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.Session;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import fr.ifremer.adagio.core.dao.data.vessel.VesselOwnerPeriod;
import fr.ifremer.adagio.core.dao.data.vessel.VesselOwnerPeriodImpl;

/**
 * Check that vessel owner periods are sane.
 * <p/>
 * 
 * @author Benoit Lavenier <benoit.lavenier@e-is.pro>
 * @since 3.5
 */
public class DatabaseSanityTaskVesselOwnerPeriod implements DatabaseSanityTask {

	/** Logger. */
	private static final Log log = LogFactory.getLog(DatabaseSanityTaskVesselOwnerPeriod.class);

	@Override
	public Set<String> sanity(Session currentSession) {

		Set<String> cacheIds = Sets.newHashSet();

		// get all VESSEL_OWNER_PERIOD with more than one unclosed period
		Query query = currentSession.createQuery(
				"SELECT id.vessel.code FROM " +
						VesselOwnerPeriodImpl.class.getName()
						+ " WHERE endDateTime IS NULL GROUP BY id.vessel.code HAVING COUNT(*)>1");
		List<String> vesselCodes = query.list();

		if (CollectionUtils.isEmpty(vesselCodes)) {
			if (log.isInfoEnabled()) {
				log.info("vesselOwnerPeriods are sane");
			}
			return cacheIds;
		}

		for (String vesselCode : vesselCodes) {

			// Get all features having a null endDatetime
			Query query1 = currentSession
					.createQuery(
							"SELECT id FROM "
									+ VesselOwnerPeriodImpl.class.getName()
									+
									" WHERE endDateTime IS NULL AND id.vessel.code = :vesselCode ORDER BY id.startDateTime DESC")
					.setString("vesselCode", vesselCode);

			List<VesselOwnerPeriod> vesselOwnerPeriods = Lists.<VesselOwnerPeriod> newArrayList(query1.list());

			// remove first id (this one will stay on db)
			vesselOwnerPeriods.remove(0);

			// remove all others ids
			if (log.isWarnEnabled()) {
				log.warn(String.format("Remove %d bad VesselOwnerPeriod for vessel: %s",
						vesselOwnerPeriods.size(), vesselCode));
			}
			currentSession.createQuery(
					"DELETE FROM " + VesselOwnerPeriodImpl.class.getName()
							+ " WHERE vesselOwnerPeriodPk IN :vesselOwnerPeriodPk").
					setParameterList("vesselOwnerPeriodPk", vesselOwnerPeriods).executeUpdate();
		}

		currentSession.setFlushMode(FlushMode.COMMIT);
		currentSession.flush();

		// clean vessel caches
		// clean vessel caches
		cacheIds.add("fishingVessels");
		cacheIds.add("vesselByCode");

		return cacheIds;
	}
}
